// This class is used to provide access to iCal by using the iCalEventPlugIn widget plug-in

// This tells if the plug-in can be used
var iCalPluginUsable = false;
// This holds a list of all the calendar UIDs that were gotten from the plug-in 
var calendarUIDs = null;
// This is a constant of the text used as the last item in the Repeat list
var iCalRepeatItemText = "iCal Repeat";
// This is the special URL for opening iCal when the front image is clicked instead of
// going to a website
var openICalImageUrl = "open iCal";

// This method will try to initialize the iCal plug-in
function initializePlugin() {
	// Check if the plug in is found
	// Find the OS version to make sure the iCalEventPlugIn call is not made in 10.4
	var osVersion = navigator.appVersion;
	var startMacOS = osVersion.indexOf("Mac OS X ");
	if((startMacOS != -1) && (osVersion.substring(startMacOS + 9, startMacOS + 13) != "10_4")) {
		// The OS is not 10.4 so try the plugin
		if(iCalEventPlugIn) {
			iCalPluginUsable = iCalEventPlugIn.isSupported();
			if(iCalPluginUsable == false) {
				// We need to hide the iCal check box
				document.getElementById("iCal_checkboxbutton").style.visibility = "hidden";
				// Also make sure the checkbox check is off
				document.getElementById("iCal_checkbox_check").checked = false;
				usingICalTemplateSetting = false;
			} else if(usingICalTemplateSetting) {
				// The iCal checkbox should be checked
				document.getElementById("iCal_checkbox_check").checked = true;
			}
		}
	}
}

/**
This method will fill the template 1 popup with the iCal calendars
*/
function fillTemplate1WithiCal() {
	var tempPopup = document.getElementById("Template1_popup");
	// Remove all values from the popup
	while(tempPopup.length > 0) {
		// Remove the last value
		tempPopup.remove(tempPopup.length - 1);
	}
	// The None object should always be added
	tempPopup.appendChild(new Option("None", 0));
	// Make sure the calendar UIDs have been found
	if(calendarUIDs == null) {
		// The UIDs have not been gotten yet so try to get them
		calendarUIDs = iCalEventPlugIn.calendarUIDS();
	}
	// At this point the UIDs could still be null so check before we use them
	if(calendarUIDs != null) {
		// Now add all the template values to the list
		for(var i = 0; i < calendarUIDs.length; i++) {
			// Add this item to the popup by getting the name of the calendar and setting its UID
			tempPopup.appendChild(new Option(iCalEventPlugIn.nameOfCalendarWithUID(calendarUIDs[i]), calendarUIDs[i]));
		}
	}
}

/**
This method will be called when the iCal checkbox is clicked
*/
function iCalCheckboxClicked() {
	// For now just fill out the template one which should handle the rest of the stuff
	fillTemplate1();
}

/**
This is called when template one changes its value and it needs to fill in the template 2
popup box
temp1Val:String The string url of the current value in temp1Val or 0 for 
the None item
tempPopup:Popup The popup box HTML object that needs to be populated. 
At this point it is empty
updateTemplate2:Boolean This tells if the template 2 should be updated
which will cause a change in the date/time
return: The new updateTemplate2 value if it changed or the one passed in if it did not change
*/
function iCalTemplate2Fill(temp1Val, tempPopup, updateTemplate2) {
	// Make sure that the iCal url is not 0 or the None item
	if(temp1Val != "0") {
		// The template value is a URL to get the event data for them
		// First find the UIDs for the events given this calendar
		var uids = iCalEventPlugIn.eventUIDSForCalendarWithUID(temp1Val);
		// Make sure all the values are valid
		if(uids != null) {
			// All the values are valid so fill the popup with the values
			for(var i = 0; i < uids.length; i++) {
				// Add this option to the popup with the name as the label and uid as the value
				tempPopup.appendChild(new Option(iCalEventPlugIn.eventNameWithUID(uids[i]), uids[i]));
			}
		}
		// Even if there are no events in the list the reload button should be enabled
		document.getElementById("Reload_button").object.setEnabled(true);
	}
	
	var repeatPopup = document.getElementById("Repeat_popup");
	if(tempPopup.length == 0) {
		// There are no items in the popup so disable it
		tempPopup.disabled = true;
		// Make sure that there is not a iCal Repeat item
		if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
			repeatPopup.remove(repeatPopup.length - 1);
			// Make sure the Repeat popup value change is triggered
			handleRepeatValue();					
		}
	} else {
		// The popup has values so it should be enabled
		tempPopup.disabled = false;
	}
	// Return the updateTemplate2 value
	return updateTemplate2;
}

/**
This method is called when the template 2 popup box changes and the iCal button is checked
temp2Val:String The current value of the template 2 popup box
*/
function iCalTemplate2Change(temp2Val) {
	// Get the name of the iCal event
	var eventName = iCalEventPlugIn.eventNameWithUID(temp2Val);
	// Fill the text field with a value
	document.getElementById("EventTitle_textfield").value = "Countdown to " + eventName;
	// Fill in the URL fo this event to have if one has been set
	var eventUrl = iCalEventPlugIn.eventUrlForUID(temp2Val);
	if(eventUrl != null) {
		// Set this as the URL
		setImageLinkText(eventUrl, false);
	} else {
		// Set the default iCal URL to be used since one is not set yet
		setImageLinkText(openICalImageUrl, false);
	}
	
	// Check if the event repeats or not
	var repeatPopup = document.getElementById("Repeat_popup");
	if(iCalEventPlugIn.doesEventRepeatForUID(temp2Val)) {
		// Make sure there is a iCal Repeat item for the Repeat popup
		if(repeatPopup[repeatPopup.length - 1].text != iCalRepeatItemText) {
			repeatPopup.appendChild(new Option(iCalRepeatItemText, "20"));
		}
		// Set the value of the popup to iCal Repeat
		repeatPopup.value = "20";
	} else {
		// Make sure that there is not a iCal Repeat item
		if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
			repeatPopup.remove(repeatPopup.length - 1);
		}
		// Set the value of the popup to never
		repeatPopup.value = "0";
	}
	// Make sure the Repeat popup value change is triggered
	handleRepeatValue();
	// Now initialize all the values with the events date and time
	var dateTime = iCalEventPlugIn.eventOccurenceForUID(temp2Val);
	var dateObj = new Date(dateTime);
	// Set the month day and year using the dateObj
	setMonthDayAndYear(dateObj.getMonth(), dateObj.getDate() - 1, dateObj.getFullYear());
	// Set the time popup values for the item
	var hours = dateObj.getHours();
	if(hours < 12) {
		// It should be am and hours should be used as is
		document.getElementById("AMPM_popup").value = 0;
		document.getElementById("Hour_popup").value = hours;
	} else {
		// It should be pm and hours should 12 less
		document.getElementById("AMPM_popup").value = 1;
		document.getElementById("Hour_popup").value = hours - 12;
	}
	// Set the minutes and seconds as is
	document.getElementById("Minute_popup").value = dateObj.getMinutes();
	document.getElementById("Second_popup").value = dateObj.getSeconds();	
}

/**
This function will change the iCal Template to None and should be called when the user
changes one of the date or time popups or the repeat popup
*/
function changeiCalTemplateBackToNone() {
	// Get the template one popup and make sure it is not already set to none before we change it
	var temp1Popup = document.getElementById("Template1_popup");
	if(temp1Popup.value != 0) {
		// The template is not set to None yet so first make sure the iCal specific repeat item is removed
		var repeatPopup = document.getElementById("Repeat_popup");
		if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
			repeatPopup.remove(repeatPopup.length - 1);
		}
		// Set the template value back to none and force the change event
		temp1Popup.value = 0;
		template1Change();
	}
}

/**
This method will try to preload the iCal event that was loaded from the preferences
just incase the occurence date for the event has changed
*/
function preloadiCalEvent() {
	// First make sure that iCal is enabled
	if((usingICalTemplateSetting) && (iCalPluginUsable)) {
		// Now try to make sure the calendar with the given event is loaded
		iCalEventPlugIn.eventUIDSForCalendarWithUID(template1Setting);
		// Now try to get the date string for the event
		var eventDate = iCalEventPlugIn.eventOccurenceForUID(template2Setting);
		// Check if the event exist or not by seeing if we go a date
		if(eventDate != null) {
			// The event was found so update the properties because they could have changed
			countdownStringSetting = eventDate;
			daySetting = (new Date(countdownStringSetting)).getDate() - 1;
			if(iCalEventPlugIn.doesEventRepeatForUID(template2Setting)) {
				// The event repeats so the setting should be 20
				repeatSetting = 20;
			} else {
				// The event does not repeat so the setting should be 0
				repeatSetting = 0;
			}
			// Save the settings and use them
			saveProperties();
			useSettings();
			if(repeatSetting == 20) {
				// Make sure iCal Repeating is in the repeat popup
				var repeatPopup = document.getElementById("Repeat_popup");
				if(repeatPopup[repeatPopup.length - 1].text != iCalRepeatItemText) {
					repeatPopup.appendChild(new Option(iCalRepeatItemText, "20"));
				}
			}
		} else {
			// The event was not found so change the event template to none
			template1Setting = 0;
			template2Setting = 0;
		}
	} else {
		// iCal support was not found so turn off iCal events
		template1Setting = 0;
		template2Setting = 0;
		document.getElementById("iCal_checkbox_check").checked = false;
		usingICalTemplateSetting = false;
	}
}

/**
This will use the current iCal template information to compute the repeat value for
the current event that is being counted down
@return A string for the next time occurance for the event or null if none exists
*/
function findNextEventOccurance() {
	var nextTimeStr = null;
	
	// Make sure that iCal is enabled
	if((iCalPluginUsable) && (usingICalTemplateSetting)) {
		// Ask the plug in to refresh the event list for the current calendar (Template 1)
		iCalEventPlugIn.refreshEventsInCalendarWithUID(template1Setting);
		// Now try to get the occurance string for the event (Template 2)
		nextTimeStr = iCalEventPlugIn.eventOccurenceForUID(template2Setting);
		if(nextTimeStr != null) {
			// Check to see if the event still repeats
			if(iCalEventPlugIn.doesEventRepeatForUID(template2Setting) == false) {
				// Remove the iCal repeat item from the popup and update the repeat value
				var repeatPopup = document.getElementById("Repeat_popup");
				if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
					repeatPopup.remove(repeatPopup.length - 1);
				}
				repeatSetting = 0;
				repeatPopup.value = 0;
			}
		}
	}
	
	// return the next time string that was created
	return nextTimeStr;
}

/**
This will reload the iCal events based on the current calendar that is selected
*/
function reloadICalEvents() {
	// Get the current calendar UID
	var temp1Value = document.getElementById("Template1_popup").value;
	// Make sure a valid calendar is selected
	if(temp1Value != 0) {
		iCalEventPlugIn.refreshEventsInCalendarWithUID(temp1Value);
		// Now refill the template one list
		template1Change();
	}
}
