
// These properties are used for loading the Web - Yearly Days data
var webYearTemplatesLoaded = false;
var httpYearRequest = null;
var webYearTemplates = null;
var webYearURL = "http://widgets.ebsgaming.com/countdown/webyearly.xml";
var webYearCallback = null;

// These properties are used for loading the Web - Misc
var webMiscTemplatesLoaded = false;
var httpMiscRequest = null;
var webMiscTemplates = null;
var webMiscURL = "http://widgets.ebsgaming.com/countdown/webmisc.xml";
var webMiscCallback = null;

//////////////////////////////////////////////////////////
// This is the class that is used to store a web template

/**
This will parse the DOM element passed into the method filling up the
WebTemplate object so that it has parsed out all the needed values
tempRoot:DOMElement The root of a template entry it should have the name
   of template and have child elements defining the values
*/
function webTemplateParse(tempRoot) {
	var valid = false;
	// Make sure the element has the right name
	if((tempRoot != null) && (tempRoot.nodeName == "template")) {
		// Things look valid
		valid = true;
		// Loop through all the elements children
		for (var item = tempRoot.firstChild; item != null; item = item.nextSibling) {
			// Make sure the element has a child
			if(item.firstChild != null) {
				// Check to see if this node name of the child is a known element
				if(item.nodeName == "short-name") {
					// It is the short name
					this.shortName = getItemsTextValue(item);
				} else if(item.nodeName == "long-name") {
					// It is the long name
					this.longName = getItemsTextValue(item);
				} else if(item.nodeName == "id") {
					// It is the id
					this.id = getItemsTextValue(item);
				} else if(item.nodeName == "date") {
					// It is the date string
					this.date = getItemsTextValue(item);
				} else if((item.nodeName == "image") || (item.nodeName == "img")) {
					// It is the image path
					this.image = getItemsTextValue(item);
				} else if(item.nodeName == "web-link") {
					// It is the link string
					this.link = getItemsTextValue(item);
				}
			} else if(item.nodeName == "deprecated-2-0") {
				// The template is no longer needed for 2.0 so it is not valid to add
				valid = false;
			}
		}
	}
	return valid;
}

// This is the class itself used to store a web template entry
function WebTemplate() {
	// Set all the class variables to null
	this.id = null;
	this.shortName = null;
	this.longName = null;
	this.date = null;
	this.image = null;
	this.link = "";
	this.parse = webTemplateParse;
}

// End of WebTemplate class
///////////////////////////////////////////////////////////////////


/**
This method will get the text value of the item node passed in. It will find the first
child that is of type text node and contains a non null node value or empty string
itemNode:DOMElement The item node to get the text value for
return A string for the element that was found or "no-image" if no element was found
*/
function getItemsTextValue(itemNode) {
	var textValue = "no-image";
	// Loop through all the elements
	for (var item = itemNode.firstChild; item != null; item = item.nextSibling) {
		if(item.nodeName == "#text") {
			// It is a text node so see if the value is not an empty string
			if((item.nodeValue != null) && (item.nodeValue != "")) {
				// The node has the value we want so get it
				textValue = item.nodeValue;
				// We found the item so we can leave
				break;
			}
		}
	}
	// Return the value that was found
	return textValue;
}

/**
This method is used to load all the web templates for the given http request
to the given url
httpRequest:XMLHttpRequest An XML Http Request object that is already created
   and has its onload callback method set
httpURL:String a URL for the request to try to load from
*/
function loadWebTemplates(httpRequest, httpURL) {
	// Setup the httpRequest so it is ready to get the data 
    httpRequest.overrideMimeType("text/xml");
    httpRequest.open("GET", httpURL);
    httpRequest.setRequestHeader("Cache-Control", "no-cache");

    // Send the request asynchronously
    httpRequest.send(null);
}

/**
This method is used for the yearly web days templates onload method
for the httpRequest:XMLHttpRequest
e:Object The event for the method
*/
function onloadYearly(e) {
	var feedRootElement = null;
	if (httpYearRequest.responseXML) {
		feedRootElement = httpYearRequest.responseXML.documentElement;
	}

	// Process the loaded document
	if(feedRootElement != null) {
		// Make sure the tag name is web-template
		if(feedRootElement.tagName == "web-template") {
			// We have a valid template
			var webTemp = null;
			// Loop through all the children
			for (var item = feedRootElement.firstChild; item != null; item = item.nextSibling) {
				// Check to make sure the element is a template
				if (item.nodeName == "template") {
					// Now create a template and parse the item
					webTemp = new WebTemplate();
					if(webTemp.parse(item)) {
						// Now add this item to the yearly web template array
						webYearTemplates.push(webTemp);
						webTemp = null;
					}
				}
			}
		}
	}
		
	// Check to see if there is a callback method to load
	if(webYearCallback != null) {
		// Call the callback passing in the templates
		webYearCallback(webYearTemplates);
	}
	
	// The web yearly templates have been loaded
	webYearTemplatesLoaded = true;
	// Request is no longer pending
	httpYearRequest = null;
}

/**
This will load the web yearly templates if they have not been loaded yet
calling back the callback method with the loaded templates afterwards.
If they have been loaded then already then the callback method will be
called imedently with the web template items
callback:function The callback function that takes in an array of WebTemplates
*/
function loadWebYearlyTemplates(callback) {
	if(callback != null) {
		// Save the callback function but do not overwrite the current callback
		// if a null method
		webYearCallback = callback;
	}
	// Check if loading has started or is complete
	if((webYearTemplatesLoaded == false) && (httpYearRequest == null)) {
		// Loading has not started so set everything up
		httpYearRequest = new XMLHttpRequest();
		httpYearRequest.onload = onloadYearly;
		// Now create an array to hold all the templates
		webYearTemplates = new Array();
		// Start the load process
		loadWebTemplates(httpYearRequest, webYearURL);
	} else if(webYearTemplatesLoaded == true) {
		// The web templates have been loaded so call the callback if it exists
		if(webYearCallback != null) {
			webYearCallback(webYearTemplates);
		}
	}
}

/**
This method is used for the misc web days templates onload method
for the httpRequest:XMLHttpRequest
e:Object The event for the method
*/
function onloadMisc(e) {
	var feedRootElement = null;
	if (httpMiscRequest.responseXML) {
		feedRootElement = httpMiscRequest.responseXML.documentElement;
	}

	// Process the loaded document
	if(feedRootElement != null) {
		// Make sure the tag name is web-template
		if(feedRootElement.tagName == "web-template") {
			// We have a valid template
			var webTemp = null;
			// Loop through all the children
			for (var item = feedRootElement.firstChild; item != null; item = item.nextSibling) {
				// Check to make sure the element is a template
				if (item.nodeName == "template") {
					// Now create a template and parse the item
					webTemp = new WebTemplate();
					if(webTemp.parse(item)) {
						// Now add this item to the misc web template array
						webMiscTemplates.push(webTemp);
						webTemp = null;
					}
				}
			}
		}
	}
		
	// Check to see if there is a callback method to load
	if(webMiscCallback != null) {
		// Call the callback passing in the templates
		webMiscCallback(webMiscTemplates);
	}
	
	// The web yearly templates have been loaded
	webMiscTemplatesLoaded = true;
	// Request is no longer pending
	httpMiscRequest = null;
}

/**
This will load the web misc templates if they have not been loaded yet
calling back the callback method with the loaded templates afterwards.
If they have been loaded then already then the callback method will be
called imedently with the web template items
callback:function The callback function that takes in an array of WebTemplates
*/
function loadWebMiscTemplates(callback) {
	if(callback != null) {
		// Save the callback function but do not overwrite the current callback
		// if a null method
		webMiscCallback = callback;
	}
	// Check if loading has started or is complete
	if((webMiscTemplatesLoaded == false) && (httpMiscRequest == null)) {
		// Loading has not started so set everything up
		httpMiscRequest = new XMLHttpRequest();
		httpMiscRequest.onload = onloadMisc;
		// Now create an array to hold all the templates
		webMiscTemplates = new Array();
		// Start the load process
		loadWebTemplates(httpMiscRequest, webMiscURL);
	} else if(webMiscTemplatesLoaded == true) {
		// The web templates have been loaded so call the callback if it exists
		if(webMiscCallback != null) {
			webMiscCallback(webMiscTemplates);
		}
	}
}

/**
This function will return the web template that was found in the array of
web templates passed in under the given id passed in
templateArray:Array An array of web templates to search
tempId:String The id of the template to get
return: A WebTemplate or null if a matching template was not found
*/
function getWebTemplateInternal(templateArray, tempId) {
	var webTemp = null;
	
	// Check if the array is null
	if(templateArray != null) {
		// Loop through the array of templates looking for one that has the same id
		for(var i = 0; i < templateArray.length; i++) {
			if(templateArray[i].id == tempId) {
				// We found a match so save it and exit the loop
				webTemp = templateArray[i];
				break;
			}
		}
	}
	
	// Return the web template that was found
	return webTemp;
}

/**
This function will return the web template that was gotten for the given
type that has the specific id passed in
templateType:Number The type of web template to get 0 = yearly, 1 = misc.
tempId:String The id of the template to get
return: A WebTemplate or null if a matching template was not found
*/
function getWebTemplate(templateType, tempId) {
	var webTemp = null;
	// Handle the type of the template
	if(templateType == 0) {
		// Check the yearly web templates
		webTemp = getWebTemplateInternal(webYearTemplates, tempId);
	} else if(templateType == 1) {
		// Check the misc web templates
		webTemp = getWebTemplateInternal(webMiscTemplates, tempId);
	}
	
	// Return the web template that was found
	return webTemp;
}

/**
This function will reload the web template for the current template 1 that is selected
*/
function reloadWebTemplate() {
	// Get the current calendar UID
	var temp1Value = document.getElementById("Template1_popup").value;
	// Make sure a valid calendar is selected
	if((temp1Value == 5) || (temp1Value == 6)) {
		// It is a web template like it should be so remove all the template 2 items
		if(temp1Value == 5) {
			// The yearly templates should be unloaded
			webYearTemplatesLoaded = false;
			webYearTemplates = null;
		} else {
			// The misc templates should be unloaded
			webMiscTemplatesLoaded = false;
			webMiscTemplates = null;
		}
		// Now have the template 1 fill the template 2 list which will restart the reload process
		template1Change();
	}
}
