// This is for checking to see if there is a newer version of the widget currently available

// These properties are used for check the version
var widgetVersion = "2.0";
var updateChecked = false;
var updateRequest = null;
var updateURL = "http://widgets.ebsgaming.com/countdown/update.xml";
// These are for storing the information found from the update xml
var releasedVersion = null;
var updateImageURL = null;
var updateImageClick = null;
var updateAvailable = false;

// These are for links to the title on the back being clicked on
var widgetTitleLink = "http://widgets.ebsgaming.com/countdown.php";
var ebsgStarLink = "http://www.ebsgaming.com";


/**
This will start the check for version updates if they have not been checked 
or started to check yet.
*/
function checkForVersionUpdate() {
	// Make sure the title version has the right text value
	document.getElementById("Title_Version_text").innerText = "EBSG Countdown v" + widgetVersion;
	// Check if loading has started or is complete
	if((updateChecked == false) && (updateRequest == null)) {
		// Loading has not started so set everything up
		updateRequest = new XMLHttpRequest();
		updateRequest.onload = onloadUpdate;
		// Setup the httpRequest so it is ready to get the data 
		updateRequest.overrideMimeType("text/xml");
		updateRequest.open("GET", updateURL);
		updateRequest.setRequestHeader("Cache-Control", "no-cache");

		// Send the request asynchronously
		updateRequest.send(null);
	}
	// Else do nothing
}

/**
This method is used for the update check onload method
for the httpRequest:XMLHttpRequest
e:Object The event for the method
*/
function onloadUpdate(e) {
	var feedRootElement = null;
	if (updateRequest.responseXML) {
		feedRootElement = updateRequest.responseXML.documentElement;
	}

	// Process the loaded document
	if(feedRootElement != null) {
		// Make sure the tag name is update-info
		if(feedRootElement.tagName == "update-info") {
			// Loop through all the children
			for (var item = feedRootElement.firstChild; item != null; item = item.nextSibling) {
				// Check for the different update info data
				// Make sure the element has a child
				if(item.firstChild != null) {
					// Check to see if this node name of the child is a known element
					if(item.nodeName == "released-version") {
						// It is the release version
						releasedVersion = item.firstChild.nodeValue;
					} else if(item.nodeName == "image-url") {
						// It is the url for the image to show if there is a new version
						updateImageURL = item.firstChild.nodeValue;
					} else if(item.nodeName == "update-link") {
						// It is the url to show if there is an update available
						updateImageClick = item.firstChild.nodeValue;
					}
				}
			}
		}
	}
	
	// The udpates have been checked
	updateChecked = true;
	// Request is no longer pending
	updateRequest = null;
	
	if(releasedVersion != null) {
		// Now handle the checking if a new version is available
		handleUpdateResults();
	}
}

/**
This will handle the data collected from the update.xml file to see if 
a new version or special message should be shown
*/
function handleUpdateResults() {
	// Check to see if the released version is different
	if((widgetVersion != releasedVersion) && (updateImageURL != null) && (updateImageClick != null)) {
		// An update or info is available
		updateAvailable = true;
		// Change the image
		document.getElementById("Update_Image").src = updateImageURL;
	}
}

/**
If an update is available this will go to the URL stored in updateImageClick
*/
function updateImageClickedOn() {
	if(updateAvailable) {
		// There is an update available so go to the given image click site
		widget.openURL(updateImageClick);
	}
}

/**
This will go to the widgets webpage when the widget title is clicked on
*/
function titleVersionClickedOn() {
	// Go to this web page for the widget
	widget.openURL(widgetTitleLink);
}

/**
This will go to EBS Gamings homepage when the star image is clicked on
*/
function starClickedOn() {
	// Go to ebs gaming homepage
	widget.openURL(ebsgStarLink);
}
