// This file is used for handling all the interal templates

// This will hold the iCal event entries for the template popup 2
var iCalEventEntries = new Array();

/**
This is called by all components when a part of the template has been changed
it will do nothing if the template is doing the changing
*/
function templateEdit() {
	// You can edit the name and not change the template for iCal events
	if((changingTemplate == false) && (document.getElementById("iCal_checkbox_check").checked == false)) {
		// Set the template value back to none and force the change event
		document.getElementById("Template1_popup").value = 0;
		template1Change();
	}
}

/**
This is called by all components when a part of the template has been changed
it will do nothing if the template is doing the changing
*/
function handleTemplateEdit() {
	// You can edit the name and not change the template for iCal events
	if(changingTemplate == false) {
		if(document.getElementById("iCal_checkbox_check").checked == false) {
			// Call the TempalateEdit method
			templateEdit();
		} else {
			// It is an iCal template so change it to back to the None template
			changeiCalTemplateBackToNone();
		}
	}
}

/**
This is called when template one changes its value
*/
function template1Change() {
	template1ChangeHandler(true);
}

/**
This is called when template one changes its value
updateTemplate2:Boolean This tells if the template 2 should be updated
which will cause a change in the date/time
*/
function template1ChangeHandler(updateTemplate2) {
	var tempVal;
	var tempPopup;
	// The template it taking control of changing the components
	changingTemplate = true;
	
	// Get the value of the template
	tempVal = document.getElementById("Template1_popup").value;
	
	// Clear all items from the template 2
	tempPopup = document.getElementById("Template2_popup");
	// Remove all values from the popup
	while(tempPopup.length > 0) {
		// Remove the last value
		tempPopup.remove(tempPopup.length - 1);
	}
	
	// By default disable the reload button
	document.getElementById("Reload_button").object.setEnabled(false);
	
	// Check if the iCal events should be filled in instead
	if(document.getElementById("iCal_checkbox_check").checked) {
		// The iCal events should be filled in
		updateTemplate2 = iCalTemplate2Fill(tempVal, tempPopup, updateTemplate2);
	} else {
		// Make sure there is no iCal Repeat item for the Repeat popup
		var repeatPopup = document.getElementById("Repeat_popup");
		if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
			repeatPopup.remove(repeatPopup.length - 1);
			// Make sure the Repeat popup value change is triggered
			handleRepeatValue();
		}
		// Now populate template 2 with the correct values based on template 1's value
		if(tempVal == 1) {
			// School
			// Add the items to the template popup and make it enabled
			tempPopup.disabled = false;
			tempPopup.appendChild(new Option("Years First Day", 0));
			tempPopup.appendChild(new Option("End of School Day", 1));
			tempPopup.appendChild(new Option("Start of Weekend", 2));
			tempPopup.appendChild(new Option("End of Weekend", 3));
			tempPopup.appendChild(new Option("Summer Break", 4));
			tempPopup.appendChild(new Option("Winter Break", 5));
			tempPopup.appendChild(new Option("Spring Break", 6));
			tempPopup.appendChild(new Option("Graduation", 7));
		} else if(tempVal == 2) {
			// Work
			// Add the items to the template popup and make it enabled
			tempPopup.disabled = false;
			tempPopup.appendChild(new Option("First Day", 0));
			tempPopup.appendChild(new Option("End of Work Day", 1));
			tempPopup.appendChild(new Option("Start of Weekend", 2));
			tempPopup.appendChild(new Option("Start of Workweek", 3));
			tempPopup.appendChild(new Option("Holiday Party", 4));
			tempPopup.appendChild(new Option("Retirement", 5));
		} else if(tempVal == 3) {
			// Holidays
			// Add the items to the template popup and make it enabled
			tempPopup.disabled = false;
			tempPopup.appendChild(new Option("New Year's Day", 0));
			tempPopup.appendChild(new Option("M. L. King Day", 8));
			tempPopup.appendChild(new Option("Groundhog Day", 1));
			tempPopup.appendChild(new Option("Valentine's Day", 2));
			tempPopup.appendChild(new Option("Presidents' Day", 9));
			tempPopup.appendChild(new Option("St. Patrick's Day", 3));
			tempPopup.appendChild(new Option("Earth Day", 10));
			tempPopup.appendChild(new Option("Mother's Day", 11));
			tempPopup.appendChild(new Option("Memorial Day", 12));
			tempPopup.appendChild(new Option("Father's Day", 13));
			tempPopup.appendChild(new Option("Fourth of July", 4));
			tempPopup.appendChild(new Option("Labor Day", 14));
			tempPopup.appendChild(new Option("Columbus Day", 15));
			tempPopup.appendChild(new Option("Halloween", 5));
			tempPopup.appendChild(new Option("Veteran's Day", 6));
			tempPopup.appendChild(new Option("Thanksgiving", 16));
			tempPopup.appendChild(new Option("Christmas", 7));
		} else if(tempVal == 4) {
			// Special Occasions
			// Add the items to the template popup and make it enabled
			tempPopup.disabled = false;
			tempPopup.appendChild(new Option("Birthday", 0));
			tempPopup.appendChild(new Option("Anniversary", 1));
			tempPopup.appendChild(new Option("Vacation", 2));
			tempPopup.appendChild(new Option("Wedding Day", 3));
			tempPopup.appendChild(new Option("50th Birthday", 4));
			tempPopup.appendChild(new Option("Apple's Birthday", 5));
		} else if(tempVal == 5) {
			// Web Yearly days
			// For now this option should be empty and disabled
			tempPopup.disabled = true;
			// Try to fill the template 2 popup
			makeSureWebYearlyTemplatesLoaded();
			if(tempPopup.length > 0) {
				// The template has already been updated
				updateTemplate2 = false;
			}
			// The reload button for web templates should be enabled
			document.getElementById("Reload_button").object.setEnabled(true);
		} else if(tempVal == 6) {
			// Web Misc.
			// For now this option should be empty and disabled
			tempPopup.disabled = true;
			// Try to fill the template 2 popup
			makeSureWebMiscTemplatesLoaded();
			if(tempPopup.length > 0) {
				// The template has already been updated
				updateTemplate2 = false;
			}
			// The reload button for web templates should be enabled
			document.getElementById("Reload_button").object.setEnabled(true);			
		} else {
			// Make sure the popup is disabled
			tempPopup.disabled = true;
		}
	}
	// Else template 2 should not be populated
	if((updateTemplate2) && (tempPopup.disabled == false)) {
		// Force the firing of the template 2 change event
		template2Change();
	}
	
	// The template changing is complete
	changingTemplate = false;
}


/**
This methos will handle the time string converting it to the popup values
timeStr:String The time string in the format of ##:##:##
*/
function timeToPopups(timeStr) {
	// Get the hours minutes and seconds
	var hours = goodParseInt(timeStr.substring(0, 2));
	var minutes = goodParseInt(timeStr.substring(3, 5));
	var seconds = goodParseInt(timeStr.substring(6));
	// Now setting the minutes and seconds is easy
	document.getElementById("Minute_popup").value = minutes;
	document.getElementById("Second_popup").value = seconds;
	// Hours is 0-23 based when it needs to be 1-12 with a am and pm
	if(hours < 12) {
		// It is am and the hours correspond 1 to 1 with the hour values
		document.getElementById("Hour_popup").value = hours;
		document.getElementById("AMPM_popup").value = 0;
	} else {
		// It is pm and the hours are 12 more then the values
		document.getElementById("Hour_popup").value = (hours - 12);
		document.getElementById("AMPM_popup").value = 1;
	}
}

/**
This is called when template two changes its value
*/
function template2Change() {
	var tempVal = document.getElementById("Template1_popup").value;
	var temp2Val = document.getElementById("Template2_popup").value;
	var eTitle = document.getElementById("EventTitle_textfield");
	// By default the time should be midnight and the link should be an empty string
	var timeStr = "00:00:00";
	var imageLink = "";
	
	// The template it taking control of changing the components
	changingTemplate = true;
	
	// Handle if the iCal events should be loaded or not
	if(document.getElementById("iCal_checkbox_check").checked) {
		if(tempVal != 0) {
			// The iCal events should be loaded and not the normal values
			iCalTemplate2Change(temp2Val);
			// The image should always be the clock by default
			setBackImageByName("Clock");
		} else {
			// None is selected so make sure the iCal repeat option is not pickable
			var repeatPopup = document.getElementById("Repeat_popup");
			if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
				repeatPopup.remove(repeatPopup.length - 1);
			}
		}
	} else {
		// Handle the template 1 choose
		if(tempVal == 1) {
			// School
			// End of Schol day is repeat on weekdays only
			if(temp2Val == 1) {
				document.getElementById("Repeat_popup").value = 5;
			} else if((temp2Val == 2) || (temp2Val == 3)) {
				// Start of weekend and end of week end is repeat weekly
				document.getElementById("Repeat_popup").value = 3;
			} else {
				// Everything else is repeat never
				document.getElementById("Repeat_popup").value = 0;
			}
			// Make sure the repeat value is changed
			handleRepeatValue();
			
			// Handle the different choices
			if(temp2Val == 0) {
				// Years First Day start on a Wednesday at midnight in August after the 20th
				var dayVal = 20;
				var monthVal = 7;
				var yearVal = currentTime.getFullYear();
				var newDateObj = null;
				var moveAmount = 0;
				var dayofweek;
				// If we should try the next year
				if((currentTime.getMonth() > 7) || ((currentTime.getMonth() == 7) && 
					(currentTime.getDate() > 20))) {
					// Move to the next year
					yearVal++;
				}
				// Create a new date object for this value so we can pick a wednesday
				newDateObj = new Date(dayVal + " Aug " + yearVal + " "
					+ timeStr);
				// Get the day of the week of this date
				dayofweek = newDateObj.getDay();
				if(dayofweek != 3) {
					// We need to move forward to get to the right day
					if(dayofweek < 3) {
						// We need to move forward to Wednesday
						moveAmount = 3 - dayofweek;
					} else {
						// We need to go to the next week to get Wednesday
						moveAmount = (10 - dayofweek);
					}
					// Move to the right day
					dayVal += moveAmount;
				}
				// Setup all the properties
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				eTitle.value = "Countdown to First Day of School Year";
				// Setup the image to use
				setBackImageByName("Book");
			} else if(temp2Val == 1) {
				timeStr = "15:30:00";
				eTitle.value = "Time Left in School Day";
				// Setup the image to use
				setBackImageByName("Clock");			
			} else if(temp2Val == 2) {
				// Start of Weekend should be Friday at 3:30pm
				timeStr = "15:30:00";
				document.getElementById("Day_popup").value = 5;
				eTitle.value = "Countdown to Weekend";
				// Setup the image to use
				setBackImageByName("Clock");			
			} else if(temp2Val == 3) {
				// Start of school week should be Monday at 8:30am
				timeStr = "08:30:00";
				document.getElementById("Day_popup").value = 1;
				eTitle.value = "Countdown to Start of School Week";
				// Setup the image to use
				setBackImageByName("Book");			
			} else if(temp2Val == 4) {
				// Summer Break start on the first Friday in June at 3:30 pm
				var dayVal = 1;
				var monthVal = 5;
				var yearVal = currentTime.getFullYear();
				var newDateObj = null;
				var moveAmount = 0;
				var dayofweek;
				timeStr = "15:30:00";
				// If we should try the next year
				if(currentTime.getMonth() >= 5) {
					// Move to the next year
					yearVal++;
				}
				// Create a new date object for this value so we can pick a Friday
				newDateObj = new Date(dayVal + " June " + yearVal + " "
					+ timeStr);
				// Get the day of the week of this date
				dayofweek = newDateObj.getDay();
				if(dayofweek != 5) {
					// We need to move forward to get to the right day
					if(dayofweek < 5) {
						// We need to move forward to Friday
						moveAmount = 5 - dayofweek;
					} else {
						// day of the week is Saturday so move forward 6 days
						moveAmount = 6;
					}
					// Move to the right day
					dayVal += moveAmount;
				}
				// Setup all the properties
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				eTitle.value = "Countdown to Summer Break";
				// Setup the image and link to use
				setBackImageByName("Sun");
				imageLink = "http://en.wikipedia.org/wiki/Summer_vacation";		
			} else if(temp2Val == 5) {
				// Winter Break start on the first Friday before the 24th the at 3:30 pm
				var dayVal = 23;
				var monthVal = 11;
				var yearVal = currentTime.getFullYear();
				var newDateObj = null;
				var moveAmount = 0;
				var dayofweek;
				timeStr = "15:30:00";
				// If we should try the next year
				if((currentTime.getMonth() == 11) && (currentTime.getDate() > 16)) {
					// Move to the next year
					yearVal++;
				}
				// Create a new date object for this value so we can pick a Friday
				newDateObj = new Date(dayVal + " Dec " + yearVal + " "
					+ timeStr);
				// Get the day of the week of this date
				dayofweek = newDateObj.getDay();
				if(dayofweek != 5) {
					// We need to move backward to get to the right day
					if(dayofweek < 5) {
						// We need to move back to Friday
						moveAmount = dayofweek + 2;
					} else {
						// day of the week is Saturday so move back 1 day
						moveAmount = 1;
					}
					// Move to the right day
					dayVal -= moveAmount;
				}
				// Setup all the properties
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				eTitle.value = "Countdown to Winter Break";
				// Setup the image to use
				setBackImageByName("Snowman");			
			} else if(temp2Val == 6) {
				// Spring Break start on the first Friday in March after or at the 15th at 3:30 pm
				var dayVal = 15;
				var monthVal = 2;
				var yearVal = currentTime.getFullYear();
				var newDateObj = null;
				var moveAmount = 0;
				var dayofweek;
				timeStr = "15:30:00";
				// If we should try the next year
				if((currentTime.getMonth() > 2) || ((currentTime.getMonth() == 2) && 
					(currentTime.getDate() > 14))) {
					// Move to the next year
					yearVal++;
				}
				// Create a new date object for this value so we can pick a Friday
				newDateObj = new Date(dayVal + " March " + yearVal + " "
					+ timeStr);
				// Get the day of the week of this date
				dayofweek = newDateObj.getDay();
				if(dayofweek != 5) {
					// We need to move forward to get to the right day
					if(dayofweek < 5) {
						// We need to move forward to Friday
						moveAmount = 5 - dayofweek;
					} else {
						// day of the week is Saturday so move forward 6 days
						moveAmount = 6;
					}
					// Move to the right day
					dayVal += moveAmount;
				}
				// Setup all the properties
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				// Setup the image and image link to use
				setBackImageByName("Flower");
				imageLink = "http://en.wikipedia.org/wiki/Spring_break";		
			} else if(temp2Val == 7) {
				// Graduation should be May 31st at 8:00 pm
				var dayVal = 31;
				var monthVal = 4;
				var yearVal = currentTime.getFullYear();
				timeStr = "20:00:00";
				// If we should try the next year
				if((currentTime.getMonth() > 4) || ((currentTime.getMonth() == 4) && 
					(currentTime.getDate() > 25))) {
					// Move to the next year
					yearVal++;
				}
				// Setup all the properties
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				eTitle.value = "Countdown to My Graduation";
				// Setup the image and link to use
				setBackImageByName("Graduation");
				imageLink = "http://en.wikipedia.org/wiki/Graduation";
			}
			// Setup the time for the event
			timeToPopups(timeStr);
		} else if(tempVal == 2) {
			// Work
			// First day, holiday party and retirement are not repeating
			if((temp2Val == 0) || (temp2Val == 4) || (temp2Val == 5)) {
				document.getElementById("Repeat_popup").value = 0;
			} else if(temp2Val == 1) {
				// End of work day is weekdays repeat only
				document.getElementById("Repeat_popup").value = 5;
			} else if((temp2Val == 2) || (temp2Val == 3)) {
				// Start of weekend and workweek are weekly
				document.getElementById("Repeat_popup").value = 3;
			}
			// Make sure the repeat value is changed
			handleRepeatValue();
			
			// Handle the different choices
			if(temp2Val == 0) {
				// First day should start on a monday at 9am in a month
				var monthNames = [ "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", 
				"Sept", "Oct", "Nov", "Dec" ];
				var dayVal = currentTime.getDate();
				var monthVal = currentTime.getMonth() + 1;
				var yearVal = currentTime.getFullYear();
				var newDateObj = null;
				var moveAmount = 0;
				var dayofweek;
				timeStr = "09:00:00";
				// Check for a wrap around in month
				if(monthVal >= 12) {
					// Move to January increasing the year
					monthVal = 0;
					yearVal++;
				}
				// Cap the day value at 28
				if(dayVal >= 29) {
					dayVal = 28;
				}
				// Create a new date object for this value so we can pick a monday
				newDateObj = new Date(dayVal + " " + monthNames[monthVal] + " " + yearVal + " "
					+ timeStr);
				// Get the day of the week of this date
				dayofweek = newDateObj.getDay();
				if((dayofweek != 1) && (dayVal < 7)) {
					// We need to move forward to get to the right day
					if(dayofweek == 0) {
						// Go forward one day to be Monday
						moveAmount = 1;
					} else {
						// Move back until we are at Monday
						moveAmount = (8 - dayofweek);
					}
					dayVal += moveAmount;
				} else if(dayofweek != 1) {
					// We should move backwards
					if(dayofweek == 0) {
						// Go forward one day to be Monday
						moveAmount = 6;
					} else {
						// Move back until we are at Monday
						moveAmount = (dayofweek - 1);
					}
					dayVal -= moveAmount;
				}
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				eTitle.value = "Countdown to First Day of Work";
				// Setup the image to use
				setBackImageByName("Work");			
			} else if(temp2Val == 1) {
				// End of workday
				timeStr = "17:00:00";
				eTitle.value = "Time Left in Workday";
				// Setup the image to use
				setBackImageByName("Clock");			
			} else if(temp2Val == 2) {
				// Start of Weekend should be Friday at 5pm
				timeStr = "17:00:00";
				document.getElementById("Day_popup").value = 5;
				eTitle.value = "Countdown to Weekend";
				// Setup the image to use
				setBackImageByName("Clock");			
			} else if(temp2Val == 3) {
				// Start of Workweek should be Monday at 9am
				timeStr = "09:00:00";
				document.getElementById("Day_popup").value = 1;
				eTitle.value = "Countdown to Start of Workweek";
				// Setup the image to use
				setBackImageByName("Work");			
			} else if(temp2Val == 4) {
				// Holiday party should be December 1st of the current year or next
				// Starting at 6pm
				timeStr = "18:00:00";
				var yearVal = currentTime.getFullYear();
				if(currentTime.getMonth() == 11) {
					// Move to the next year
					yearVal = yearVal + 1;
				}
				setMonthDayAndYear(11, 0, yearVal);
				eTitle.value = "Countdown to Holiday Party";
				// Setup the image to use
				setBackImageByName("Xmas Tree");			
			} else if(temp2Val == 5) {
				// Retirement should be in 20 years from today but cap the day at 28
				// and starting at 5pm
				timeStr = "17:00:00";
				var dayVal = 0;
				if(currentTime.getDate() >= 29) {
					// Cap the value at 28
					dayVal = 27;
				} else {
					// Use the current date changing it to zero based
					dayVal = currentTime.getDate() - 1;
				}
				setMonthDayAndYear(currentTime.getMonth(), dayVal, currentTime.getFullYear() + 20);
				eTitle.value = "Countdown to My Retirement";
				// Setup the image and link to use
				setBackImageByName("Beach");
				imageLink = "http://www.ssa.gov/retirement/";			
			}
			// Setup the time for the event
			timeToPopups(timeStr);
		} else if(tempVal == 3) {
			// Holidays
            if((temp2Val < 8) || (temp2Val == 10)) {
                // The repeat value is always yearly for the first set
                document.getElementById("Repeat_popup").value = 1;      
            } else {
                // The repeat value is always advanced yearly for the second set
                document.getElementById("Repeat_popup").value = 7;              
            }
            handleRepeatValue();
            // For all these the time is always midnight so no change is needed
			// Handle the different choices
			if(temp2Val == 0) {
				// New Year's Day which is Jan 1st
				setMonthAndDay(0, 0);
				eTitle.value = "Countdown to the New Year";
				// Setup the image and link to use
				setBackImageByName("Clock");
				imageLink = "http://en.wikipedia.org/wiki/New_Year";		
			} else if(temp2Val == 1) {
				// Groundhog Day which is Feb 2nd
				setMonthAndDay(1, 1);
				eTitle.value = "Countdown to Groundhog Day";
				// Setup the image and link to use
				setBackImageByName("Groundhog");
				imageLink = "http://www.groundhog.org/";	
			} else if(temp2Val == 2) {
				// Valentine's Day which is Feb 14th
				setMonthAndDay(1, 13);
				eTitle.value = "Countdown to Valentine's Day";
				// Setup the image and image to use
				setBackImageByName("Heart");
				imageLink = "http://en.wikipedia.org/wiki/Valentine's_Day";
			} else if(temp2Val == 3) {
				// St. Patrick's Day which is March 17nd
				setMonthAndDay(2, 16);
				eTitle.value = "Countdown to St. Patrick's Day";
				// Setup the image and link to use
				setBackImageByName("Clover");
				imageLink = "http://en.wikipedia.org/wiki/Saint_Patrick%27s_Day";	
			} else if(temp2Val == 4) {
				// Fourth of July which is July 4th
				setMonthAndDay(6, 3);
				eTitle.value = "Countdown to Fourth of July";
				// Setup the image and image to use
				setBackImageByName("US Flag");
				imageLink = "http://www.usa.gov/Topics/Independence_Day.shtml";	
			} else if(temp2Val == 5) {
				// Halloween which is October 31th
				setMonthAndDay(9, 30);
				eTitle.value = "Countdown to Halloween";
				// Setup the image and link to use
				setBackImageByName("Jackolantern");
				imageLink = "http://en.wikipedia.org/wiki/Halloween";
			} else if(temp2Val == 6) {
				// Veteran's Day which is November 11th
				setMonthAndDay(10, 10);
				eTitle.value = "Countdown to Veteran's Day";
				// Setup the image and link to use
				setBackImageByName("US Flag");
				imageLink = "http://www1.va.gov/opa/vetsday/";
			} else if(temp2Val == 7) {
				// Christmas which is December 25th
				setMonthAndDay(11, 24);
				eTitle.value = "Countdown to Christmas";
				// Setup the image and link to use
				setBackImageByName("Xmas Tree");
				imageLink = "http://en.wikipedia.org/wiki/Christmas";	
			} else if(temp2Val == 8) {
				// M. L. King Day which is the third Monday in January
				setMonthAndDay(0, 1);
                document.getElementById("Repeat_Extra_popup").value = 3;
				eTitle.value = "Countdown to Martin Luther King Day";
				// Setup the image and link to use
				setBackImageByName("M.L. King");
				imageLink = "http://www.mlkday.gov/";
			} else if(temp2Val == 9) {
				// Presidents' Day which is the third Monday in February
				setMonthAndDay(1, 1);
                document.getElementById("Repeat_Extra_popup").value = 3;
				eTitle.value = "Countdown to Presidents' Day";
				// Setup the image and link to use
				setBackImageByName("US Flag");
				imageLink = "http://en.wikipedia.org/wiki/Washington's_Birthday";	
			} else if(temp2Val == 10) {
				// Earth Day which is April 22nd
				setMonthAndDay(3, 21);
				eTitle.value = "Countdown to Earth Day";
				// Setup the image and link to use
				setBackImageByName("Earth");
				imageLink = "http://en.wikipedia.org/wiki/Earth_Day";	
			} else if(temp2Val == 11) {
				// Mother's Day which is the second Sunday in May
				setMonthAndDay(4, 0);
                document.getElementById("Repeat_Extra_popup").value = 2;
				eTitle.value = "Countdown to Mother's Day";
				// Setup the image and link to use
				setBackImageByName("Baby");
				imageLink = "http://en.wikipedia.org/wiki/Mother%27s_Day_%28United_States%29";	
			} else if(temp2Val == 12) {
				// Memorial Day which is the last Monday in May
				setMonthAndDay(4, 1);
                document.getElementById("Repeat_Extra_popup").value = 5;
				eTitle.value = "Countdown to Memorial Day";
				// Setup the image and link to use
				setBackImageByName("US Flag");
				imageLink = "http://www1.va.gov/opa/speceven/memday/";	
			} else if(temp2Val == 13) {
				// Father's Day which is the thrid Sunday in June
				setMonthAndDay(5, 0);
                document.getElementById("Repeat_Extra_popup").value = 3;
				eTitle.value = "Countdown to Father's Day";
				// Setup the image and link to use
				setBackImageByName("Baby");
				imageLink = "http://en.wikipedia.org/wiki/Father%27s_Day";	
			} else if(temp2Val == 14) {
				// Labor Day which is the first Monday in September
				setMonthAndDay(8, 1);
                document.getElementById("Repeat_Extra_popup").value = 1;
				eTitle.value = "Countdown to Labor Day";
				// Setup the image and link to use
				setBackImageByName("US Flag");
				imageLink = "http://www.usa.gov/Topics/Labor_Day.shtml";	
			} else if(temp2Val == 15) {
				// Columbus Day which is the second Monday in October
				setMonthAndDay(9, 1);
                document.getElementById("Repeat_Extra_popup").value = 2;
				eTitle.value = "Countdown to Columbus Day";
				// Setup the image and link to use
				setBackImageByName("Boat");
				imageLink = "http://en.wikipedia.org/wiki/Columbus_Day";	
			} else if(temp2Val == 16) {
				// Thanksgiving which is the fourth Thursday in November
				setMonthAndDay(10, 4);
                document.getElementById("Repeat_Extra_popup").value = 4;
				eTitle.value = "Countdown to Thanksgiving Day";
				// Setup the image and link to use
				setBackImageByName("Turkey");
				imageLink = "http://en.wikipedia.org/wiki/Thanksgiving_(United_States)";	
			}
			// Setup the time for the event
			timeToPopups(timeStr);
		} else if(tempVal == 4) {
			// Special Occasions
			// For all but the vacation the time should stay at midnight
			if(temp2Val == 2) {
				// Vacation we will say it starts at seven in the morning
				timeStr = "07:00:00";
			}
			// For all birthday, anniversary, and Apple's birthday repeat should be yearly
			// for the rest repeat should be never
			if((temp2Val == 0) || (temp2Val == 1) || (temp2Val == 5)) {
				// Repeats should be yearly
				document.getElementById("Repeat_popup").value = 1;
			} else {
				// Repeats should be never
				document.getElementById("Repeat_popup").value = 0;
			}
			// Make sure repeat value change is called
			handleRepeatValue();
			// Handle the different choices
			if(temp2Val == 0) {
				// Birthday so use a characters birthday that I came up with
				setMonthAndDay(3, 25);
				eTitle.value = "Countdown to My Birthday";
				// Setup the image and link to use
				setBackImageByName("Cake");	
				imageLink = "http://en.wikipedia.org/wiki/Birthday";
			} else if(temp2Val == 1) {
				// Anniversary so use Valentine's Day
				setMonthAndDay(1, 13);
				eTitle.value = "Countdown to My Anniversary";
				// Setup the image and link to use
				setBackImageByName("Ring");	
				imageLink = "http://en.wikipedia.org/wiki/Wedding_anniversary";
			} else if(temp2Val == 2) {
				// Vacation so set it to be in one month from today
				var monthVal = currentTime.getMonth() + 1;
				var yearVal = currentTime.getFullYear();
				var dayVal = currentTime.getDate();
				// Make sure it does not wrap around
				if(monthVal >= 12) {
					// Move to the next year
					monthVal = 0;
					yearVal++;
				}
				// Make sure the day is not over 28
				if(dayVal > 28) {
					dayVal = 28;
				}
				// Change the day value to zero based
				setMonthDayAndYear(monthVal, dayVal - 1, yearVal);
				eTitle.value = "Countdown to My Vacation";
				// Setup the image and link to use
				setBackImageByName("Beach");
				imageLink = "http://en.wikipedia.org/wiki/Holiday";
			} else if(temp2Val == 3) {
				// Wedding Day so use Valentine's Day in a year
				setMonthDayAndYear(1, 13, currentTime.getFullYear() + 1);
				eTitle.value = "Countdown to My Wedding Day";
				// Setup the image and link to use
				setBackImageByName("Ring");
				imageLink = "http://en.wikipedia.org/wiki/Wedding";
			} else if(temp2Val == 4) {
				// Birthday so use a characters birthday that I came up with
				// and have it take place in 10 years from now
				setMonthDayAndYear(3, 25, currentTime.getFullYear() + 10);
				eTitle.value = "Countdown to My 50th Birthday";
				// Setup the image and link to use
				setBackImageByName("Cake");	
				imageLink = "http://en.wikipedia.org/wiki/Birthday";
			} else if(temp2Val == 5) {
				// Apple's Birthday which is April 1st
				setMonthAndDay(3, 0);
				eTitle.value = "Countdown to Apple's Birthday";
				// Setup the image and link to use
				setBackImageByName("Apple");
				imageLink = "http://www.apple.com/";
			}
			// Setup the time for the event
			timeToPopups(timeStr);
		} else if(tempVal == 5) {
			// Web Yearly Days
			var webTemp;
			// The repeat should aways be never so set it and update
			document.getElementById("Repeat_popup").value = 0;
			handleRepeatValue();
			// Try to get the web template that was picked
			webTemp = getWebTemplate(0, temp2Val);
			fillPopupsWithWebTemplate(webTemp);
			// Get the image link from the template if one exists
			if(webTemp != null) {
				imageLink = webTemp.link;
			}		
		} else if(tempVal == 6) {
			// Web Misc.
			var webTemp;
			// The repeat should aways be never so set it and update
			document.getElementById("Repeat_popup").value = 0;
			handleRepeatValue();
			// Try to get the web template that was picked
			webTemp = getWebTemplate(1, temp2Val);
			fillPopupsWithWebTemplate(webTemp);
			// Get the image link from the template if one exists
			if(webTemp != null) {
				imageLink = webTemp.link;
			}
		}
		// Try to set the image link
		setImageLinkText(imageLink, false);		
	}
	
	// The template changing is complete
	changingTemplate = false;
}

/**
This method will fill all the popups and event title with the
values from the web template passed in
webTemp:WebTemplate The web template to fill the popups with
*/
function fillPopupsWithWebTemplate(webTemp) {
	// Make sure the template is not null
	if(webTemp != null) {
		// Create a date object for the template
		var tempDate = new Date(webTemp.date);
		var hours = tempDate.getHours();
		var imageId = getImageIdByUrl(webTemp.image);
		// Set the event title
		document.getElementById("EventTitle_textfield").value = webTemp.longName;
		// Set the time popup values for the template
		if(hours < 12) {
			// It should be am and hours should be used as is
			document.getElementById("AMPM_popup").value = 0;
			document.getElementById("Hour_popup").value = hours;
		} else {
			// It should be pm and hours should 12 less
			document.getElementById("AMPM_popup").value = 1;
			document.getElementById("Hour_popup").value = hours - 12;
		}
		// Set the minutes and seconds as is
		document.getElementById("Minute_popup").value = tempDate.getMinutes();
		document.getElementById("Second_popup").value = tempDate.getSeconds();
		// Now set the month, day and year popups
		setMonthDayAndYear(tempDate.getMonth(), tempDate.getDate() - 1, tempDate.getFullYear());
		// Set the image used by the template
		document.getElementById("Image_popup").value = imageId;
		imagePopupChange();
		if(imageId == 100) {
			// It is an external image being used so set the external image path
			document.getElementById("Image_URL_textfield").value = webTemp.image;
			// Make sure the image url is updated
			imageURLChange();
		}
	} else {
		// There is no template so set the template 1 and 2 to 0
		document.getElementById("Template1_popup").value = 0;
		document.getElementById("Template2_popup").value = 0;
		// Update the template 1
		template1Change();
	}
}

/**
This method will preload all the web templates so they are ready
for viewing when the template popup chooses a web category
*/
function preLoadWebTemplates() {
	loadWebYearlyTemplates(null);
	loadWebMiscTemplates(null);
}

/**
This method will fill the template 2 popup box with the values with the
web templates that are passed into this method
webTemplates:Array An array of web templates to fill the template2 popup with
*/
function fillWebTemplate2(webTemplates) {
	// Get the template 2 and the template 1 value
	var tempVal = document.getElementById("Template1_popup").value;
	var tempPopup = document.getElementById("Template2_popup");
	
	// Make sure the template 1 value is still a web template
	if((tempVal == 5) || (tempVal == 6)) {
		// Make sure the template2 popup is empty by removing all values from the popup
		while(tempPopup.length > 0) {
			// Remove the last value
			tempPopup.remove(tempPopup.length - 1);
		}		
		// Make sure the web template list is valid and not empty
		if((webTemplates != null) && (webTemplates.length > 0)) {
			// Loop through all the web templates
			var webTemp = null;
			for(var i = 0; i < webTemplates.length; i++) {
				// Get the web template
				webTemp = webTemplates[i];
				// Add its data to the popup
				tempPopup.appendChild(new Option(webTemp.shortName, webTemp.id));
			}
			// There are items in the popup so enable it
			tempPopup.disabled = false;
			// Now force a fire of template2 change
			template2Change();
		} else {
			// There are no templates so disable the popup
			tempPopup.disabled = true;
		}
	}
}

/**
This method will start the loading process of web yearly templates
if it has not been started yet and should be called when the 
Web-Yearly Days popup item is selected so that it can fill the popup
with the correct values
*/
function makeSureWebYearlyTemplatesLoaded() {
	loadWebYearlyTemplates(fillWebTemplate2);
}

/**
This method will start the loading process of web misc templates
if it has not been started yet and should be called when the 
Web-Misc. popup item is selected so that it can fill the popup
with the correct values
*/
function makeSureWebMiscTemplatesLoaded() {
	loadWebMiscTemplates(fillWebTemplate2);
}

/**
This method will fill the template 1 popup with either the values from the 
default template or the iCal calendars if the iCal checkbox is checked
*/
function fillTemplate1() {
	// Check if the iCal checkbox is checked
	if(document.getElementById("iCal_checkbox_check").checked) {
		// We need to fill the template popup with the calendars
		fillTemplate1WithiCal();
	} else {
		// We need to fill the template popup with the default values
		// but first we need to clear the items in the popup
		// Clear all items from the template 2
		var tempPopup = document.getElementById("Template1_popup");
		var tempValues = ["None", "School", "Work", "Holidays", "Special Occasions", "Web - Yearly Days",
			"Web - Misc."];
		// Remove all values from the popup
		while(tempPopup.length > 0) {
			// Remove the last value
			tempPopup.remove(tempPopup.length - 1);
		}
		// Now add all the template values to the list
		for(var i = 0; i < tempValues.length; i++) {
			// Add this item to the popup
			tempPopup.appendChild(new Option(tempValues[i], i));
		}
	}
	// Now make sure that the template 1 value is marked as being changed
	template1ChangeHandler(true);
}

/**
This method is used to set the month, day and year popup boxes with values
and is done in such a way that the day popup will always have the right amount
of days for the given month in it This will set the day even if the day popup is disabled
month:Number A number for the month in the range of 0-11
day:Number A number for the day of the month which is zero based so Feburary 28th would be day 27
year:Number The given year to set
*/
function setMonthDayAndYear(month, day, year) {
	// Set the year first
	document.getElementById("Year_popup").value = year;
	// Now set the month and day using that specific method
	setMonthAndDay(month, day);
}

/**
This method is used to set the month, and day popup boxes with values
and is done in such a way that the day popup will always have the right amount
of days for the given month in it. This will set the day even if the day popup is disabled
month:Number A number for the month in the range of 0-11
day:Number A number for the day of the month which is zero based so Feburary 28th would be day 27
*/
function setMonthAndDay(month, day) {
	// Set the month first
	document.getElementById("Month_popup").value = month;
	// Now make sure the day popup is initialized correclty for the month and year value
	var dapPopup = document.getElementById("Day_popup");
	updateDayPopup();
	dapPopup.value = day;
}
