// This is for handling all the preferences for the widget that are stored and are also unqiue
// to a given instance of the widget

// These are properties that are stored and kept thoughout
// The following are preferences from v1.0
var repeatSetting;
var daySetting;
var countdownStringSetting;
var eventTitleSetting;
var template1Setting;
var template2Setting;
var imageIdSetting;
var imagePathSetting;
var imagePositionSetting;
// The following are preferences from v1.3
var imageLinkURLSetting;
var imageLinkOnSetting;
var imageLinkLockedSetting;
var frontColorThemeSetting;
var showYearsSetting;
var showExtraSetting;
var showTimeSetting;
var showJustTimeSetting;
// The following preference is from v1.5
var usingICalTemplateSetting;
// The following repeat preferences are from v2.0
var repeatUntilSetting;
var repeatExtraSetting;

// This has to be changed for release so you can have multiple instances
var keyIdentifier = widget.identifier +
	"-com.ebsg.widget.EBSGCountdown-37362474";
	
/**
This method will load properties from the widget so they can be used
by the program
*/
function loadProperties() {
	var ident = keyIdentifier;
	// Load a property that we know doesn't exist for undefined
	var notdefined = widget.preferenceForKey(ident + "-" + "blabla-undefined");
	// Load the repeat setting
	repeatSetting = widget.preferenceForKey(ident + "-" + "repeatSetting");
	if(repeatSetting == notdefined) {
		// Set the value to be Yearly
		repeatSetting = 1;
	}
	// Load the day setting
	daySetting = widget.preferenceForKey(ident + "-" + "daySetting");
	if(daySetting == notdefined) {
		// Set this value to be zero or 1
		daySetting = 0;
	}
	// Load the count down target setting
	countdownStringSetting = widget.preferenceForKey(ident + "-" + "countdownSetting");
	if(countdownStringSetting == notdefined) {
		// Set this value to be january 1st of the next year at midnight
		var newDate = new Date();
		countdownStringSetting = "1 Jan " + (newDate.getFullYear() + 1) + " 00:00:00";
	}
	// Load the event title setting
	eventTitleSetting = widget.preferenceForKey(ident + "-" + "eventTitleSetting");
	if(eventTitleSetting == notdefined) {
		// Set this value to be The New Year
		eventTitleSetting = "Countdown to the New Year";
	}
	// Load the two template settings
	template1Setting = widget.preferenceForKey(ident + "-" + "template1Setting");
	if(template1Setting == notdefined) {
		// Set this value to be none
		template1Setting = 0;
	}
	template2Setting = widget.preferenceForKey(ident + "-" + "template2Setting");
	if(template2Setting == notdefined) {
		// Set this value to be zero
		template2Setting = 0;
	}
	// Load the three image settings
	imageIdSetting = widget.preferenceForKey(ident + "-" + "imageIdSetting");
	if(imageIdSetting == notdefined) {
		// Set this value to be the clock
		imageIdSetting = getImageIdByName("Clock");
	}
	imagePathSetting = widget.preferenceForKey(ident + "-" + "imagePathSetting");
	if(imagePathSetting == notdefined) {
		// Set this value to be the path from the image id
		var imageData = getImageDataById(imageIdSetting);
		if(imageData != null) {
			// Use the image datas path
			imagePathSetting = imageData.path;
		} else {
			// Set the path to be the clock
			imagePathSetting = "CDImages/Clock.png";
		}
	}
	imagePositionSetting = widget.preferenceForKey(ident + "-" + "imagePositionSetting");
	if(imagePositionSetting == notdefined) {
		// Set this to be both or 1
		imagePositionSetting = "1";
	}
	// Load the three image link settings
	imageLinkURLSetting = widget.preferenceForKey(ident + "-" + "imageLinkURLSetting");
	if(imageLinkURLSetting == notdefined) {
		// Set this to be a link to wikipedia
		imageLinkURLSetting = "http://en.wikipedia.org/wiki/New_Year";
	}
	imageLinkOnSetting = widget.preferenceForKey(ident + "-" + "imageLinkOnSetting");
	if(imageLinkOnSetting == notdefined) {
		// Set this to true or on
		imageLinkOnSetting = true;
	} else if(imageLinkOnSetting == "true") {
		// Make the variable a boolean and not a string
		imageLinkOnSetting = true;
	} else {
		// Make the variable a boolean and not a string
		imageLinkOnSetting = false;
	}
	imageLinkLockedSetting = widget.preferenceForKey(ident + "-" + "imageLinkLockedSetting");
	if(imageLinkLockedSetting == notdefined) {
		// Set this to be a false or not locked
		imageLinkLockedSetting = false;
	} else if(imageLinkLockedSetting == "true") {
		// Make the variable a boolean and not a string
		imageLinkLockedSetting = true;
	} else {
		// Make the variable a boolean and not a string
		imageLinkLockedSetting = false;
	}
	// Get the front color theme preference
	frontColorThemeSetting = widget.preferenceForKey(ident + "-" + "frontColorThemeSetting");
	if(frontColorThemeSetting == notdefined) {
		// Set this to be Red or 9
		frontColorThemeSetting = "9";
	}
	// Get the front show value preferences
	showYearsSetting = widget.preferenceForKey(ident + "-" + "showYearsSetting");
	if(showYearsSetting == notdefined) {
		// Set this to be Off or 0
		showYearsSetting = "0";
	}
	showExtraSetting = widget.preferenceForKey(ident + "-" + "showExtraSetting");
	if(showExtraSetting == notdefined) {
		// Set this to be Weeks or 1
		showExtraSetting = "1";
	}
	showTimeSetting = widget.preferenceForKey(ident + "-" + "showTimeSetting");
	if(showTimeSetting == notdefined) {
		// Set this to be Hours, Minutes and seconds or 3
		showTimeSetting = "3";
	}
	showJustTimeSetting = widget.preferenceForKey(ident + "-" + "showJustTimeSetting");
	if(showJustTimeSetting == notdefined) {
		// Set this to be Never or 0
		showJustTimeSetting = "0";
	}
	usingICalTemplateSetting = widget.preferenceForKey(ident + "-" + "usingICalTemplateSetting");
	// Make sure the iCal setting is a boolean value
	if(usingICalTemplateSetting == notdefined) {
		// Set this to be a false or not locked
		usingICalTemplateSetting = false;
	} else if(usingICalTemplateSetting == "true") {
		// Make the variable a boolean and not a string
		usingICalTemplateSetting = true;
	} else {
		// Make the variable a boolean and not a string
		usingICalTemplateSetting = false;
	}
    // Now load the v2.0 repeat settings
	repeatUntilSetting = widget.preferenceForKey(ident + "-" + "repeatUntilSetting");
	if(repeatUntilSetting == notdefined) {
		// Set this to an empty string
		repeatUntilSetting = "";
	}
	repeatExtraSetting = widget.preferenceForKey(ident + "-" + "repeatExtraSetting");
	if(repeatExtraSetting == notdefined) {
		// Set this to zero
		repeatExtraSetting = "0";
	}  
	// Now try to startup the iCal plug-in
	initializePlugin();
	// Make sure the template 1 combo box is in the right state
	fillTemplate1();
	// Check if a web template is currently in use
	if(usingICalTemplateSetting == false) {
		if(template1Setting == 5) {
			// A web yearly template is in use so load them all
			loadWebYearlyTemplates(webTemplateLoadedCountdown);
		} else if(template1Setting == 6) {
			// A web misc template is in use so load them all
			loadWebMiscTemplates(webTemplateLoadedCountdown);
		}
	} else {
		// make sure the event is loaded and date updated if needed
		preloadiCalEvent();
	}
	
	// Make sure the color theme is setup correctly
	updateFrontColorTheme();
	// Make sure the front images are in the right image and showing state
	setFrontImageSrc(imagePathSetting);
	handleImagePositions(imagePositionSetting);
	// Make sure the blinking colon vs period is set up correctly
	if(showTimeSetting == "3") {
		// The seconds are being shown so blink the colon not period
		wantBlinkingColon = true;
		wantBlinkingPeriod = false;
	} else {
		// The seconds are not being shown so blink the period not colon
		wantBlinkingColon = false;
		wantBlinkingPeriod = true;
	}
}

/**
This method will save properties to the widget for loading when the widget
is loaded again
*/
function saveProperties() {
	// Save the properties to the widget
	var ident = keyIdentifier;
	widget.setPreferenceForKey(repeatSetting.toString(), ident + "-" + "repeatSetting");
	widget.setPreferenceForKey(daySetting.toString(), ident + "-" + "daySetting");
	widget.setPreferenceForKey(countdownStringSetting, ident + "-" + "countdownSetting");
	widget.setPreferenceForKey(eventTitleSetting, ident + "-" + "eventTitleSetting");
	// Save the template properties
	widget.setPreferenceForKey(template1Setting.toString(), ident + "-" + "template1Setting");
	widget.setPreferenceForKey(template2Setting.toString(), ident + "-" + "template2Setting");
	// Save the image properties
	widget.setPreferenceForKey(imageIdSetting.toString(), ident + "-" + "imageIdSetting");
	widget.setPreferenceForKey(imagePathSetting, ident + "-" + "imagePathSetting");
	widget.setPreferenceForKey(imagePositionSetting.toString(), ident + "-" + "imagePositionSetting");
	// Save the image link properties
	widget.setPreferenceForKey(imageLinkURLSetting, ident + "-" + "imageLinkURLSetting");
	widget.setPreferenceForKey(imageLinkOnSetting.toString(), ident + "-" + "imageLinkOnSetting");
	widget.setPreferenceForKey(imageLinkLockedSetting.toString(), ident + "-" + "imageLinkLockedSetting");	
	// Save the color theme property
	widget.setPreferenceForKey(frontColorThemeSetting, ident + "-" + "frontColorThemeSetting");
	// Save the front digit show properties
	widget.setPreferenceForKey(showYearsSetting, ident + "-" + "showYearsSetting");
	widget.setPreferenceForKey(showExtraSetting, ident + "-" + "showExtraSetting");
	widget.setPreferenceForKey(showTimeSetting, ident + "-" + "showTimeSetting");
	widget.setPreferenceForKey(showJustTimeSetting, ident + "-" + "showJustTimeSetting");
	// Save the iCal template setting
	widget.setPreferenceForKey(usingICalTemplateSetting.toString(), ident + "-" + "usingICalTemplateSetting");
    // Save the v2.0 repeat settings
    widget.setPreferenceForKey(repeatUntilSetting.toString(), ident + "-" + "repeatUntilSetting");
    widget.setPreferenceForKey(repeatExtraSetting.toString(), ident + "-" + "repeatExtraSetting");
}

/**
This function is a callback function for when a web template has finished loading
it will find the web template with the current web template id and then update the
date currently being used
webTemplateArray:Array an array of web templates
*/
function webTemplateLoadedCountdown(webTemplateArray) {
	// Try to get the web template that is currently in use
	var webTemp = getWebTemplateInternal(webTemplateArray, template2Setting);
	if(webTemp != null) {
		// The template was found so update the properties because they could have changed
		countdownStringSetting = webTemp.date;
		daySetting = (new Date(countdownStringSetting)).getDate() - 1;
		eventTitleSetting = webTemp.longName;
		// Save the settings and use them
		saveProperties();
		useSettings();
	} else {
		// The template was not found so turn off templates
		template1Setting = 0;
		template2Setting = 0;
	}
}

/**
This is when either the left or right images on the front are clicked by the user. 
This will check if the website goto feature is on and if the URL seems valid and if
so it will open that page
*/
function handleFrontImagesClicked() {
	// First check to see if the link is on
	if(imageLinkOnSetting) {
		// The link is on so now chck to see if the web address is not null or an empty string
		if((imageLinkURLSetting != null) && (imageLinkURLSetting.length > 0)) {
			if((imageLinkURLSetting.length == openICalImageUrl.length) && 
				(imageLinkURLSetting.toLowerCase() == openICalImageUrl.toLowerCase())) {
				// This is the special case were we need to open up iCal instead of a website
				widget.openApplication("com.apple.iCal");
			} else {
				// Try to go to this link
				widget.openURL(imageLinkURLSetting);
			}
		}
	}
}

/**
This method will use the color theme property to make sure the front image
is in the correct color theme, which includes the background color, and also
the color of the event label text
*/
function updateFrontColorTheme() {
	// Var these variables are used for defining the values to set in the image and label
	var imageSrc = "FImages/red-front.png";
	// Black is the default color so set it here so we do not need to change it elsewhere
	var labelColor = "#000000";

	if(frontColorThemeSetting == "0") {
		// This is for the black color theme
		labelColor = "#FFFFFF";
		imageSrc = "FImages/black-front.png";
	} else if(frontColorThemeSetting == "1") {
		// This is for the blue color theme
		labelColor = "#FFFFFF";
		imageSrc = "FImages/blue-front.png";
	} else if(frontColorThemeSetting == "2") {
		// This is for the brown color theme
		labelColor = "#FFFFFF";
		imageSrc = "FImages/brown-front.png";
	} else if(frontColorThemeSetting == "3") {
		// This is for the cyan color theme
		imageSrc = "FImages/cyan-front.png";
	} else if(frontColorThemeSetting == "4") {
		// This is for the gray color theme
		imageSrc = "FImages/gray-front.png";
	} else if(frontColorThemeSetting == "5") {
		// This is for the green color theme
		imageSrc = "FImages/green-front.png";
	} else if(frontColorThemeSetting == "6") {
		// This is for the magenta color theme
		labelColor = "#FFFFFF";
		imageSrc = "FImages/magenta-front.png";
	} else if(frontColorThemeSetting == "7") {
		// This is for the orange color theme
		imageSrc = "FImages/orange-front.png";
	} else if(frontColorThemeSetting == "8") {
		// This is for the purple color theme
		labelColor = "#FFFFFF";
		imageSrc = "FImages/purple-front.png";
	} else if(frontColorThemeSetting == "9") {
		// This is for the red color theme
		imageSrc = "FImages/red-front.png";
	} else if(frontColorThemeSetting == "10") {
		// This is for the white color theme
		imageSrc = "FImages/white-front.png";
	} else if(frontColorThemeSetting == "11") {
		// This is for the yellow color theme
		imageSrc = "FImages/yellow-front.png";
	}
	// Get the element for the front image and the event label and then set the correct value
	// right away since we have already gotten the value
	document.getElementById("frontImg").src = imageSrc;
	document.getElementById("event-label").style.setProperty("color", labelColor);
}
