// This file is setup to handle the different images that can be displayed in the 
// widget. It handles all the selection of images along with other methods

// This is used to store all the image data that is available in the widget internally
var imageDataArray = null;


//////////////////////////////////////////////////////////
// This is the class that is used to store a image data

/**
This is the constructor for the image data object
urlPath:String The path to the file that should be used in the src of the image tag
name:String The name of the image to be shown in the popup box
id:Number The id the image data belongs to in the image data list
*/
function ImageData(urlPath, name, id) {
	// Set all the class variables to null
	this.id = id.toString();
	this.name = name;
	this.path = urlPath;
}

// End of ImageData class
///////////////////////////////////////////////////////////////////

/**
This method will setup the image data array so that it will have data
for all the images available in the CDImages folder
*/
function setupImageDataArray() {
	// First create the array
	imageDataArray = new Array();
	// Now add the items
	imageDataArray.push(new ImageData("CDImages/Clock.png", "Clock", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Apple.png", "Apple", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Baby.png", "Baby", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Beach.png", "Beach", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Boat.png", "Boat", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Book.png", "Book", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Cake.png", "Cake", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/CD.png", "CD/DVD", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Phone.png", "Cell Phone", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Clover.png", "Clover", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Computer.png", "Computer", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/EasterEgg.png", "Easter Egg", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Earth.png", "Earth", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/FallLeaf.png", "Fall Leaf", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Flower.png", "Flower", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Football.png", "Football", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Gamepad.png", "Gamepad", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Graduation.png", "Graduation", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Groundhog.png", "Groundhog", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Handheld.png", "Handheld", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Heart.png", "Heart", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Jackolantern.png", "Jackolantern", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Menorah.png", "Menorah", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/MLKing.png", "M.L. King", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Movie.png", "Movie", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Olympics.png", "Olympics", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Ring.png", "Ring", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Snowman.png", "Snowman", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Sun.png", "Sun", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Turkey.png", "Turkey", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/TV.png", "TV", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/USFlag.png", "US Flag", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Vote.png", "Vote", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/Work.png", "Work", imageDataArray.length));
	imageDataArray.push(new ImageData("CDImages/XmasTree.png", "Xmas Tree", imageDataArray.length));
}

/**
This will get the image data for a specific image defined by the given id
id:String The id to look for in the array of image data
return: The ImageData for the image found if one was or null if none was found
*/
function getImageDataById(id) {
	var imageData = null;
	
	// Loop through all the image data
	for(var i = 0; i < imageDataArray.length; i++) {
		// Check if the id matches
		if(imageDataArray[i].id == id) {
			// We have a match so save this image data object and exit the loop
			imageData = imageDataArray[i];
			break;
		}
	}
	
	// Return the image data that was found
	return imageData;
}

/**
This will try to get the id of the image by the url for the image passed in
imageUrl:String the url path for the image to look for
return: The id in the popup for the image that was found or 100 if the url was
   not found
*/
function getImageIdByUrl(imageUrl) {
	// By default set the index to return to be the external index
	var id = 100;
	
	// Loop through all the image data
	for(var i = 0; i < imageDataArray.length; i++) {
		// Check if the path matches the url
		if(imageDataArray[i].path == imageUrl) {
			// We have a match so save this id and exit the loop
			id = imageDataArray[i].id;
			break;
		}
	}
	
	// Return the index that was found
	return id;
}

/**
This will try to get the id of the image by the name for the image passed in
imageName:String the name for the image to look for
return: The id in the popup for the image that was found or 0 if the url was
   not found which should be the clock
*/
function getImageIdByName(imageName) {
	// By default set the index to return 0 which should be the clock
	var id = 0;
	
	// Loop through all the image data
	for(var i = 0; i < imageDataArray.length; i++) {
		// Check if the name matches
		if(imageDataArray[i].name == imageName) {
			// We have a match so save this id and exit the loop
			id = imageDataArray[i].id;
			break;
		}
	}
	
	// Return the index that was found
	return id;
}

/**
This will set the back image based on the name of the image to use
imageName:String the name for the image use if the name is not found the clock is used
*/
function setBackImageByName(imageName) {
	// Set the selected image
	document.getElementById("Image_popup").value = getImageIdByName(imageName);
	// Make sure the popup updates the change
	imagePopupChange();
}

/**
This method will get the image path for the given id
id:Number The id of the image data to get the path for
return: A String path for the id of the selected image. If the id was not found then the
   Image_URL_textfield value will be returned instead
*/
function getImagePath(id) {
	// By default the path should be the external image text field
	var path = document.getElementById("Image_URL_textfield").value;
	if(path == "") {
		// Make sure the path returned is not empty
		path = "enter-url-here";
	}
	
	// Loop through all the image data
	for(var i = 0; i < imageDataArray.length; i++) {
		// Check if the id matches
		if(imageDataArray[i].id == id) {
			// We have a match so save this path and exit the loop
			path = imageDataArray[i].path;
			break;
		}
	}
	
	// Return the path that was found
	return path;
}

/**
This will fill the image popup on the back of the widget so it includes all the
available images and also the External choice
*/
function fillImagePopup() {
	// Get the image popup
	var imagePop = document.getElementById("Image_popup");
	var imageData = null;
	// Only fill the popup if it has no values already
	if(imagePop.length == 0) {
		// Now loop through all the image data in the array adding their option
		for(var i = 0; i < imageDataArray.length; i++) {
			// Get the image data object
			imageData = imageDataArray[i];
			// Add this option to the image popup
			imagePop.appendChild(new Option(imageData.name, imageData.id));
		}
		
		// Now add the external option
		imagePop.appendChild(new Option("External", "100"));
		// Make sure the image is setup
		imagePopupChange();
	}
}

/**
This method will hide the front left image only
*/
function hideFrontLeftImage() {
	// Make the image invisible
	document.getElementById("Front_Image_Left").style.visibility = "hidden";
}

/**
This method will hide the front right image only
*/
function hideFrontRightImage() {
	// Make the image invisible
	document.getElementById("Front_Image_Right").style.visibility = "hidden";
}

/**
This method will hide both of the front images
*/
function hideFrontImages() {
	// Hide both the front images
	hideFrontLeftImage();
	hideFrontRightImage();
}

/**
This method will show the front left image only
*/
function showFrontLeftImage() {
	// Make the image visible
	document.getElementById("Front_Image_Left").style.visibility = "visible";
}

/**
This method will show the front right image only
*/
function showFrontRightImage() {
	// Make the image visible
	document.getElementById("Front_Image_Right").style.visibility = "visible";
}

/**
This method will show both of the front images
*/
function showFrontImages() {
	// Show both the front images
	showFrontLeftImage();
	showFrontRightImage();
}

/**
This will handle the image position by hiding or showing the front images based
on the pos passed into the method
pos:Number The value from the image position popup where 0 = None, 1 = Both, 2 = Left,
   and 3 = Right
*/
function handleImagePositions(pos) {
	// Handle the position passed in
	if(pos == 0) {
		// Hide both front images
		hideFrontImages();
	} else if(pos == 1) {
		// Show both front images
		showFrontImages();
	} else if(pos == 2) {
		// Show the left hide the right
		showFrontLeftImage();
		hideFrontRightImage();
	} else {
		// Show the right hide the left
		showFrontRightImage();
		hideFrontLeftImage();
	}
}

/**
This method will set the image to use for both of the front images even if they
are hidden and not visible at the current time
image:String The URL of the image to use
*/
function setFrontImageSrc(image) {
	// Set the image source for the image to use
	document.getElementById("Front_Image_Left").src = image;
	document.getElementById("Front_Image_Right").src = image;
}

/**
This method will set the image to use for the back image
path:String The url path for the image to set as the back image
*/
function setBackImageSrc(path) {
	document.getElementById("Back_Image").src = path;
}

/**
This methos will get the selected images url based on the image popup box
or the image url text field
return: A string for the url that should be used
*/
function getSelectedImageURL() {
	// Get the image data for the selected item
	var imageData = getImageDataById(document.getElementById("Image_popup").value);
	var srcPath = null;
	// If the image data is not null we can use it to set the source
	if(imageData != null) {
		srcPath = imageData.path;
	} else {
		// Get the text from the text area
		srcPath = document.getElementById("Image_URL_textfield").value;
	}
	// Return the source path that was found
	return srcPath;
}

// This is called when the image popup changes its value
function imagePopupChange() {
	// Get the new value of the popup
	var imageId = document.getElementById("Image_popup").value;
	var imageURL = document.getElementById("Image_URL_textfield");
	if((imageId == "100") && (imageURL.disabled)) {
		// Set the text to be some value resulting in a bad image
		imageURL.value = "enter-url-here";
		var but = document.getElementById("To_appearance");
		if(document.getElementById("To_appearance").object.enabled == false) {
			// The external image text field should be enabled
			imageURL.disabled = false;
			// Make sure both the label and url are visible since we are on the appearance label
			document.getElementById("External_Image_text").style.visibility = "visible";
			imageURL.style.visibility = "visible";
		}
	} else if(imageId != "100") {
		// The external image text field should be disabled
		imageURL.disabled = true;
		// Clear the text in the text field
		imageURL.value = "";
		// Also hide both the label and url
		document.getElementById("External_Image_text").style.visibility = "hidden";
		imageURL.style.visibility = "hidden";
	}
	// Set the back image using this popups value
	setBackImageSrc(getSelectedImageURL());
}

/**
This is called when the external image url changes. This will cause the image to update
to reflect the new URL even if it results in a bad image.
*/
function imageURLChange() {
	// Set the back image to the text fields value
	setBackImageSrc(document.getElementById("Image_URL_textfield").value);
}
