// This file handles the visiblity of the components for the front countdown display
// based on the date/time show properties. This also handles the laying out of the
// components so they use the space better then just being in their default location

// The following are default variables used for the width and offset of some key components
var twoDigitWidth = 30;
var displayWidth = 257;
var distanceToColon = 4;
var distanceToPeriod = 1;
var distanceForColon = 10;

/**
This is just a simple function that assumes you pass in a string of format #px and so it will
return the # as a integer value
styleStr:String The string in the format of #px note that no checking is done to check this format
return: An integer for the # part of the string
*/
function pixelsToInt(styleStr) {
	// We want to parse the int from the string excluding the px part of it
	return parseInt(styleStr.substring(0, styleStr.length - 2));
}

/**
This function is used to set the position of colons that go along with visible components
it will also position the period to the right position if seconds are not visible
*/
function positionColonComponents() {
	// Setup the variables to be used for checking visiblity and also positioning
	var hideState = "hidden";
	var showState = "visible";
	// This is used to store the elements that are found since they will need to be used more then once
	var displayElement = null;
	var nextElement = null;
	var nextElement = null;
	
	// Get the years style element
	displayElement = document.getElementById("remaining-years").style;
	if(displayElement.visibility == showState) {
		// Years are visible so colon1 will always be to the right of it
		labelElement = document.getElementById("colon1").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now set the left position of the colon to include the distance to the colon
		labelElement.left = (displayRight + distanceToColon) + "px";
	}
	
	// Get the extra style element
	displayElement = document.getElementById("remaining-extra").style;
	if(displayElement.visibility == showState) {
		// Extra are visible so colon2 will always be to the right of it
		labelElement = document.getElementById("colon2").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now set the left position of the colon to include the distance to the colon
		labelElement.left = (displayRight + distanceToColon) + "px";
	}
	
	// Get the days style element
	displayElement = document.getElementById("remaining-days").style;
	if(displayElement.visibility == showState) {
		// Days are visible so compute the right position of it
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);	
		// Get the hours to see if it is visible
		nextElement = document.getElementById("remaining-hours").style;
		var distanceOffset = distanceToColon;
		if(nextElement.visibility != showState) {
			// Hours are not visible so the period should be positioned instead
			labelElement = document.getElementById("period1").style;
			distanceOffset = distanceToPeriod;
		} else {
			// Hours are visible so there is a colon between them
			labelElement = document.getElementById("colon3").style;
		}
		// Now set the left position of the colon or period to include the distance offset
		labelElement.left = (displayRight + distanceOffset) + "px";
	}
	
	// Get the hours style element
	displayElement = document.getElementById("remaining-hours").style;
	if(displayElement.visibility == showState) {
		// Hours are visible so compute the right position of it
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);	
		// Get the minutes to see if it is visible
		nextElement = document.getElementById("remaining-minutes").style;
		var distanceOffset = distanceToColon;
		if(nextElement.visibility != showState) {
			// Minutes are not visible so the period should be positioned instead
			labelElement = document.getElementById("period1").style;
			distanceOffset = distanceToPeriod;
		} else {
			// Hours are visible so there is a colon between them
			labelElement = document.getElementById("colon4").style;
		}
		// Now set the left position of the colon or period to include the distance offset
		labelElement.left = (displayRight + distanceOffset) + "px";
	}
	
	// Get the minutes style element
	displayElement = document.getElementById("remaining-minutes").style;
	if(displayElement.visibility == showState) {
		// Minutes are visible so compute the right position of it
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);	
		// Get the seconds to see if it is visible
		nextElement = document.getElementById("remaining-seconds").style;
		var distanceOffset = distanceToColon;
		if(nextElement.visibility != showState) {
			// Seconds are not visible so the period should be positioned instead
			labelElement = document.getElementById("period1").style;
			distanceOffset = distanceToPeriod;
		} else {
			// Hours are visible so there is a colon between them
			labelElement = document.getElementById("colon5").style;
		}
		// Now set the left position of the colon or period to include the distance offset
		labelElement.left = (displayRight + distanceOffset) + "px";
	}
	
	// We do no have to handle the seconds since it doesn't have a colon to its right	
}

/**
This function is used to set the position of labels that go along with visible components
*/
function positionLabelComponents() {
	// Setup the variables to be used for checking visiblity and also positioning
	var showState = "visible";
	// These are used to store positions
	var displayRight = 0;
	// This is used to store the display element since it will be needed more then once
	var displayElement = null;
	var labelElement = null;
	
	// Get the years style element
	displayElement = document.getElementById("remaining-years").style;
	if(displayElement.visibility == showState) {
		// Years are visible so get the years label
		labelElement = document.getElementById("label-years").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now the label has a width of 32 so take the display right value and subtract the width
		// to get the left value for the label
		labelElement.left = (displayRight - 32) + "px";
	}
	
	// Get the extra style element
	displayElement = document.getElementById("remaining-extra").style;
	if(displayElement.visibility == showState) {
		// Extra are visible so get the extra label
		labelElement = document.getElementById("label-extra").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// The width to use for weeks verse months is differnet
		var extraWidth = 33;
		// Check if months are showing
		if(showExtraSetting == "2") {
			// Months are showing
			extraWidth = 37;
		}
		// Now take the display right value and subtract the width to get the left value for the label
		labelElement.left = (displayRight - extraWidth) + "px";
	}
	
	// Get the days style element
	displayElement = document.getElementById("remaining-days").style;
	if(displayElement.visibility == showState) {
		// Days are visible so get the days label
		labelElement = document.getElementById("label-days").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now the label has a width of 28 so take the display right value and subtract the width
		// to get the left value for the label
		labelElement.left = (displayRight - 28) + "px";
	}
	
	// Get the hours style element
	displayElement = document.getElementById("remaining-hours").style;
	if(displayElement.visibility == showState) {
		// Hours are visible so get the hours label
		labelElement = document.getElementById("label-hours").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now the label has a width of 35 so take the display right value and subtract the width
		// to get the left value for the label
		labelElement.left = (displayRight - 35) + "px";
	}
	
	// Get the minutes style element
	displayElement = document.getElementById("remaining-minutes").style;
	if(displayElement.visibility == showState) {
		// Minutes are visible so get the minutes label
		labelElement = document.getElementById("label-minutes").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now the label has a width of 25 so take the display right value and subtract the width
		// to get the left value for the label
		labelElement.left = (displayRight - 25) + "px";
	}
	
	// Get the seconds style element
	displayElement = document.getElementById("remaining-seconds").style;
	if(displayElement.visibility == showState) {
		// Seconds are visible so get the seconds label
		labelElement = document.getElementById("label-seconds").style;
		// Get the displays right most position which is left + width
		displayRight = pixelsToInt(displayElement.left) + pixelsToInt(displayElement.width);
		// Now the label has a width of 25 so take the display right value and subtract the width
		// to get the left value for the label
		labelElement.left = (displayRight - 25) + "px";
	}	
}

/**
This function is used to set the visibility as well as label names for the years,
months, days, hours, minutes, and seconds display values including the number, colon
and label. This should only be called after the preferences has been loaded.
This method does not take into account if just time should be shown or not
*/
function setDisplayComponentsVisiblity() {
	// Setup the variables to be used for setting visiblity
	var hideState = "hidden";
	var showState = "visible";
	var state = null;
	// Check if years should be visible or not
	if(showYearsSetting == "1") {
		// Years should be on
		state = showState;
	} else {
		// Years should be off
		state = hideState;
	}
	document.getElementById("remaining-years").style.visibility = state;
	document.getElementById("label-years").style.visibility = state;
	document.getElementById("colon1").style.visibility = state;
	// Check if extra should be visible or not
	if(showExtraSetting == "1") {
		// Weeks should be on and the label should say weeks
		state = showState;
		document.getElementById("label-extra").innerText = "WEEKS";
	} else if(showExtraSetting == "2") {
		// Months should be on and the label should say months
		state = showState;
		document.getElementById("label-extra").innerText = "MONTHS";
	} else {
		// Extra values should be off
		state = hideState;
	}
	document.getElementById("remaining-extra").style.visibility = state;
	document.getElementById("label-extra").style.visibility = state;
	document.getElementById("colon2").style.visibility = state;
	// Days should always be visible
	state = showState;
	document.getElementById("remaining-days").style.visibility = state;
	document.getElementById("label-days").style.visibility = state;
	
	// Check if the time should be visible or not
	var visSetting = parseInt(showTimeSetting);
	// First check if the hours are visible
	if(visSetting >= 1) {
		// Hours should be on
		state = showState;
	} else {
		// Hours should be off
		state = hideState;
	}
	document.getElementById("colon3").style.visibility = state;
	document.getElementById("remaining-hours").style.visibility = state;
	document.getElementById("label-hours").style.visibility = state;

	// Next check if the minutes are visible
	if(visSetting >= 2) {
		// Minutes should be on
		state = showState;
	} else {
		// Minutes should be off
		state = hideState;
	}
	document.getElementById("colon4").style.visibility = state;
	document.getElementById("remaining-minutes").style.visibility = state;
	document.getElementById("label-minutes").style.visibility = state;
	
	// Finally check if the seconds are visible
	if(visSetting >= 3) {
		// Seconds should be on
		state = showState;
	} else {
		// Seconds should be off
		state = hideState;
	}
	document.getElementById("colon5").style.visibility = state;
	document.getElementById("remaining-seconds").style.visibility = state;
	document.getElementById("label-seconds").style.visibility = state;	
}

/**
This will just position all the components based on their visiblity and should only be 
called by the layoutDisplayComponents function
*/
function positionDisplayComponents() {
	// Setup the variables to be used for checking visiblity and also positioning
	var showState = "visible";
	// This is used to store the elements that are found since they will need to be used more then once
	var displayElement = null;
	// We know that days will be visible but we don't know anything else about it
	// and there are two colons between them so add up their widths
	var displayCompWidth = 0;
	var oneDigitWidth = Math.ceil(twoDigitWidth / 2);
	
	// Get the years style element
	displayElement = document.getElementById("remaining-years").style;
	if(displayElement.visibility == showState) {
		// Years are visible so set the components default width
		displayElement.width = "30px";
		// Years always take up two digits width and there is always a colon after it
		displayCompWidth += (twoDigitWidth + distanceForColon);
	}
	
	// Get the extra style element
	var extraWidthUsed = 0;
	displayElement = document.getElementById("remaining-extra").style;
	if(displayElement.visibility == showState) {
		// Extra are visible so set the components default width
		displayElement.width = "88px";
		// We need to compute how many digits the extra will need to use
		if(showYearsSetting == "1") {
			// Years are being shown so we are limited to just needing two digits
			extraWidthUsed = twoDigitWidth;
		} else {
			// Years are not being shown so we need to show 4 digits
			extraWidthUsed = (oneDigitWidth * 4);
		}
		// There is also always a colon after this component
		displayCompWidth += (extraWidthUsed + distanceForColon);
	}
	
	// Get the days style element which is always visible and set the components default width
	displayElement = document.getElementById("remaining-days").style;
	displayElement.width = "130px";
	// We need to compute how many digits the days will need to use
	var daysWidthUsed = 0;
	if(showExtraSetting != "0") {
		// Either weeks or months are showing so in either case we want to take up two digits
		daysWidthUsed = twoDigitWidth;
	} else if(showYearsSetting == "1") {
		// Years are being shown but not any extra value so we need three digits to be shown
		daysWidthUsed = (oneDigitWidth * 3);
	} else {
		// Years and extra are not being shown so we need to show only 5 digits
		daysWidthUsed = (oneDigitWidth * 5);
	}
	// Now add the width used to the display component width total
	displayCompWidth += daysWidthUsed;
	
	// Get the hours style element
	displayElement = document.getElementById("remaining-hours").style;
	if(displayElement.visibility == showState) {
		// Hours are visible so set the components default width
		displayElement.width = "30px";
		// The component always uses two digits width and there is always a colon before it
		displayCompWidth += (distanceForColon + twoDigitWidth);
	}
	
	// Get the minutes style element
	displayElement = document.getElementById("remaining-minutes").style;
	if(displayElement.visibility == showState) {
		// Minutes are visible so set the components default width
		displayElement.width = "30px";
		// The component always uses two digits width and there is always a colon before it
		displayCompWidth += (distanceForColon + twoDigitWidth);		
	}
	
	// Get the seconds style element
	displayElement = document.getElementById("remaining-seconds").style;
	if(displayElement.visibility == showState) {
		// Seconds are visible so set the components default width
		displayElement.width = "30px";
		// The component always uses two digits width and there is always a colon before it
		displayCompWidth += (distanceForColon + twoDigitWidth);		
	}
	
	// Now compute the starting left position for the first display component
	var currentLeft = Math.floor((displayWidth - displayCompWidth) / 2);
	
	// Get the years style element
	displayElement = document.getElementById("remaining-years").style;
	if(displayElement.visibility == showState) {
		// Years are visible so set the left position in the element
		displayElement.left = currentLeft + "px";
		// Now move to the next component
		currentLeft += (twoDigitWidth + distanceForColon);
	}
	
	// Get the extra style element
	displayElement = document.getElementById("remaining-extra").style;
	if(displayElement.visibility == showState) {
		// Extra are visible so set the left position in the element
		// However this is more complex since we only want to set the left based on the width we want to use
		// and not the true width of the component
		displayElement.left = (currentLeft - (pixelsToInt(displayElement.width) - extraWidthUsed)) + "px";
		// Now move to the next component
		currentLeft += (extraWidthUsed + distanceForColon);		
	}
	
	// Get the days style element which is always visible so set the left position
	displayElement = document.getElementById("remaining-days").style;
	// However this is more complex since we only want to set the left based on the width we want to use
	// and not the true width of the component
	displayElement.left = (currentLeft - (pixelsToInt(displayElement.width) - daysWidthUsed)) + "px";
	// Now move to the next component
	currentLeft += (daysWidthUsed + distanceForColon);	
	
	// Get the hours style element
	displayElement = document.getElementById("remaining-hours").style;
	if(displayElement.visibility == showState) {
		// Hours are visible so set the left position in the element
		displayElement.left = currentLeft + "px";
		// Now move to the next component
		currentLeft += (twoDigitWidth + distanceForColon);		
	}
	
	// Get the minutes style element
	displayElement = document.getElementById("remaining-minutes").style;
	if(displayElement.visibility == showState) {
		// Minutes are visible so set the left position in the element
		displayElement.left = currentLeft + "px";
		// Now move to the next component
		currentLeft += (twoDigitWidth + distanceForColon);		
	}
	
	// Get the seconds style element
	displayElement = document.getElementById("remaining-seconds").style;
	if(displayElement.visibility == showState) {
		// Seconds are visible so set the left position in the element
		displayElement.left = currentLeft + "px";	
	}	
}

/**
This function is used to set the visibility as well as label names for the years, months, 
days, hours, minutes, and seconds display values including the number, colon and label and 
then it will layout the visible components so they better use the display for the countdown. 
This should only be called whenever the preferences change or a new time event is being used.
This method does not take into account if just time should be shown or not
*/
function layoutDisplayComponents() {
	// First set the visiblity of the components
	setDisplayComponentsVisiblity();
	// Now we need to layout the visible components
	positionDisplayComponents();
	// Now position the colon and labels to go along with the visible component positions
	positionColonComponents();
	positionLabelComponents();
}


/**
This function is used to set the visibility of the time components to true and the other
components to false this including the number, colon and label. 
This should only be called when just time should be shown. This fucntion does not check
the showingTimeOnly variable so it should only be called when it is set to true
*/
function setTimeOnlyDisplayComponentsVisiblity() {
	// Setup the variables to be used for setting visiblity
	var hideState = "hidden";
	var showState = "visible";
	var state = null;
	// Years should be off
	state = hideState;
	document.getElementById("remaining-years").style.visibility = state;
	document.getElementById("label-years").style.visibility = state;
	document.getElementById("colon1").style.visibility = state;
	// Extra values should be off as well
	document.getElementById("remaining-extra").style.visibility = state;
	document.getElementById("label-extra").style.visibility = state;
	document.getElementById("colon2").style.visibility = state;
	// Days should be off also
	document.getElementById("remaining-days").style.visibility = state;
	document.getElementById("label-days").style.visibility = state;
	document.getElementById("colon3").style.visibility = state;
	
	// All parts of the time should be on
	state = showState;
	// Hours should be on
	document.getElementById("remaining-hours").style.visibility = state;
	document.getElementById("label-hours").style.visibility = state;
	document.getElementById("colon4").style.visibility = state;
	// Minutes should be on as well
	document.getElementById("remaining-minutes").style.visibility = state;
	document.getElementById("label-minutes").style.visibility = state;
	document.getElementById("colon5").style.visibility = state;
	// Seconds should be in on state just like the rest of the time
	document.getElementById("remaining-seconds").style.visibility = state;
	document.getElementById("label-seconds").style.visibility = state;	
}

/**
This will just position the time components and should only be called by the 
layoutTimeOnlyDisplayComponents function
*/
function positionTimeOnlyComponents() {
	// This is used to store the elements that are found since they will need to be used more then once
	var displayElement = null;
	// We know that hours, minutes and seconds will all be visible and they are two digits in size
	// and there are two colons between them so add up their widths
	var timeCompWidth = (twoDigitWidth * 3) + (distanceForColon * 2);
	// Now compute the starting left position for the first display component
	var currentLeft = Math.floor((displayWidth - timeCompWidth) / 2);
	// Get the hours style element and set the width and left of the element
	displayElement = document.getElementById("remaining-hours").style;
	displayElement.left = currentLeft + "px";
	displayElement.width = twoDigitWidth + "px";
	// Now move to the next position
	currentLeft += twoDigitWidth + distanceForColon;
	
	// Get the minutes style element and set the width and left of the element
	displayElement = document.getElementById("remaining-minutes").style;
	displayElement.left = currentLeft + "px";
	displayElement.width = twoDigitWidth + "px";
	// Now move to the next position
	currentLeft += twoDigitWidth + distanceForColon;
	
	// Get the seconds style element and set the width and left of the element
	displayElement = document.getElementById("remaining-seconds").style;
	displayElement.left = currentLeft + "px";
	displayElement.width = twoDigitWidth + "px";
}

/**
This function is used to set the visibility of the time components to true and the other
components to false this including the number, colon and label. Then the function will layout 
the time components so they better use the display for the countdown. 
This should only be called when just time should be shown. This fucntion does not check
the showingTimeOnly variable so it should only be called when it is set to true
*/
function layoutTimeOnlyDisplayComponents() {
	// First set the time components to be visible
	setTimeOnlyDisplayComponentsVisiblity();
	// Now we need to layout the time components
	positionTimeOnlyComponents();
	// Now position the colon and labels to go along with the time component positions
	positionColonComponents();
	positionLabelComponents();
}