// This file was generated by Dashcode from Apple Inc. and has been edited a lot by me
// You may edit this file to customize your Dashboard widget.

// Pre-calculate some time constants
var msPerSecond = 1000;
var sPerMinute  = 60;
var sPerHour    = 60 * sPerMinute;
var sPerDay     = 24 * sPerHour;
var sPerWeek    = 7 * sPerDay;

// Properties set by attributes panel
var targetKind;
var countdownTarget;
var wantLeadingZeros;
var wantBlinkingColon;
var wantBlinkingPeriod;
var wantStopAtZero;
var doAction;
var zeroAction;
var iCalEventURL = "__iCalEvent__.ics";
var iCalEventSummary;
var sharediCalURL;

// This is called true when the template popup is being changed
// so all other components should not change the popup
var changingTemplate;

// JavaScript interval timer to update clock
var updateTimerDisplayInterval;

// Clock registers
var currentTime;
var remainingSeconds;
var remainingTime = new Array(6);

// Flag for whether we've reached/passed the target time
var isTargetReached = false;

// These are flags for keeping track of the year and months
// and also if just time is being shown
var checkedYear = false;
var checkedMonth = false;
var showingTimeOnly = false;


//
// Function: updateTimerDisplay()
// The main loop called by our timer interval.
// Update the clock, display the new time, and run the alarm if the target is reached.
//
function updateTimerDisplay()
{
    calculateRemainingTime();
    formatTimerDisplay();
    checkForAlarm();
}

//
// Function: formatTimerDisplay()
// Called by updateTimerDisplay() when the timer's countdown display needs to be updated.
// The remainingTime array will contain the number of days, hours, minutes, and seconds
// left until the current target event.
// Customize this function if you need to to display the time in a different way.
//
function formatTimerDisplay()
{
	setElementText("remaining-years", remainingTime[5]);
	setElementText("remaining-extra", remainingTime[4]);
    setElementText("remaining-days", remainingTime[0]);
    setElementText("remaining-hours", formatTwoDigits(remainingTime[1]));
    setElementText("remaining-minutes", formatTwoDigits(remainingTime[2]));
    setElementText("remaining-seconds", formatTwoDigits(remainingTime[3]));

    // Blink the colon or period every other second if desired
	// blinking should stop if the target has been reached
    var isVisible = "visible";
    if (((wantBlinkingColon) || (wantBlinkingPeriod)) && (isTargetReached == false)) {
        isVisible = Math.floor(currentTime / 1000) % 2 ? "hidden" : "visible";
    }
	if(wantBlinkingColon) {
		// Blink the colon
		document.getElementById("colon5").style.visibility = isVisible;
		// Make sure the period is hidden
		document.getElementById("period1").style.visibility = "hidden";
	} else if(wantBlinkingPeriod) {
		if(isTargetReached) {
			// The target is reached so the period should be hidden
			isVisible = "hidden";
		}
		// Blink the period
		document.getElementById("period1").style.visibility = isVisible;
		// Make sure the colon is hidden
		document.getElementById("colon5").style.visibility = "hidden";
	}
}

//
// Function: formatTwoDigits(number)
// Format a number as one or two digits with a leading zero if needed
//
// number: The number to format
//
// Returns the formatted number as a string.
//
function formatTwoDigits(number)
{
    var digits = number.toString(10);

    // Add a leading zero if it's only one digit long
    if (wantLeadingZeros && digits.length == 1) {
        digits = "0" + digits;
    }
    
    return digits;
}

//
// Function: setEventLabel(label)
// Format and display the countdown label
// You may need to customize this function if you remove or change the event-label div
//
// label: Text to display for the label
//
function setEventLabel(label)
{
    var eventLabelElement = document.getElementById("event-label");
    if (eventLabelElement) {
        eventLabelElement.innerText = label;
    }
}

//
// Function: setElementText(elementName, elementValue)
// Set the text contents of an HTML div
//
// elementName: Name of the element in the DOM
// elementValue: Text to display in the element
//
function setElementText(elementName, elementValue)
{
    var element = document.getElementById(elementName);
    if (element) {
        element.innerText = elementValue;
    }
}

//
// Function: checkForAlarm()
// Determine whether the target has been reached, and if so, call the alarm hook.
//
function checkForAlarm()
{
	// Make sure the time is set to zero meaning the event has happend
    if ((remainingSeconds <= 0) && (remainingTime[5] <= 0)) {
        // We're there
        if (isTargetReached == false) {
            // Make sure we only get here once if we are not repeating
            isTargetReached = true;
            // Call the alarm hook
            if (doAction && zeroAction) {
                try {
                    eval(zeroAction);
                }
                catch (exception) {
                    alert(exception);
                }
            }
		}
		if(repeatSetting != 0) {
			// Check to see if we need to go to the next count down event
			setNextCountdownTarget();
		}
    }
}

//
// Function: updateCurrentTime()
// Store the current time in the clock's internal state
//
function updateCurrentTime()
{
    currentTime = new Date();
}

//
// Function: calculateRemainingTime()
// Determine the amount of time remaining to the current target
// Result is stored in the remainingTime array as [days, hours, minutes, seconds]
//
function calculateRemainingTime()
{
	var withInYearTime = countdownTarget.eventTime;
	var yearCount = 0;
	var monthNames = [ "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", 
		"Sept", "Oct", "Nov", "Dec" ];
    // Start by getting the current date
    updateCurrentTime();
    // Clear excessive precision
    currentTime.setMilliseconds(0);
	
	if(checkedYear == false) {
		// We need to check to see if there are years
		// There could only be years if it is never repeat or yearly repeat for a 
		// Feburary 29th date
		if((repeatSetting == 0) || ((repeatSetting == 1) && (withInYearTime.getMonth() == 1)
			&& (withInYearTime.getDate() == 29))) {
			// There could be years so check for them
			if((withInYearTime.getFullYear() > (currentTime.getFullYear() + 1)) ||
				((withInYearTime.getFullYear() > currentTime.getFullYear()) && 
				((withInYearTime.getMonth() > currentTime.getMonth()) || 
				((withInYearTime.getMonth() == currentTime.getMonth()) && 
				(withInYearTime.getDate() > currentTime.getDate())) )) ) {
				// There is years left
				var dateString;
				var timeString;
				var currentYear = currentTime.getFullYear();
				// Compute how many years are left
				if(withInYearTime.getFullYear() == (currentYear + 1)) {
					// We have only one year
					yearCount = 1;
				} else {
					// Compute the difference in years
					yearCount = withInYearTime.getFullYear() - currentYear;
					// Handle the case that we are into one of those years already
					if((currentTime.getMonth() > withInYearTime.getMonth()) ||
						((currentTime.getMonth() == withInYearTime.getMonth()) &&
						(currentTime.getDate() > withInYearTime.getDate()))) {
						// The current time is after the date so decrease the year count
						// but increase the current year
						yearCount--;
						currentYear++;
					} else if((withInYearTime.getMonth() == currentTime.getMonth()) && 
						(withInYearTime.getDate() == currentTime.getDate()) &&
						(((currentTime.getHours() > withInYearTime.getHours())) ||
						((currentTime.getHours() == withInYearTime.getHours()) &&
						(currentTime.getMinutes() > withInYearTime.getMinutes())) ||
						((currentTime.getHours() == withInYearTime.getHours()) &&
						(currentTime.getMinutes() == withInYearTime.getMinutes()) &&
						(currentTime.getSeconds() > withInYearTime.getSeconds())) )) {
						// The current time is after the date so decrease the year count
						// but increase the current year
						yearCount--;
						currentYear++;						
					}
					// Else the date is before the current date so we can use the current year
					// and the year count will stay the same
				}

				// Now adjust the withInYearTime to be under one year left
				timeString = formatTwoDigits(withInYearTime.getHours()) + ":" + 
					formatTwoDigits(withInYearTime.getMinutes()) + ":" + 
					formatTwoDigits(withInYearTime.getSeconds());
				// Handle the case that the target time is the leap day
				if((withInYearTime.getMonth() == 1) && (withInYearTime.getDate() == 29) && 
					(((currentYear - 2000) % 4) != 0)) {
					// We need to handle the leap day conditions specially
					// So we will use March 1 curYear as the year to use
					dateString = "1 " + monthNames[2] + " " + currentYear;
				} else {
					// It is not a leap day so use the date like normal
					dateString = withInYearTime.getDate() + " " + 
						monthNames[withInYearTime.getMonth()] + " " + currentYear;
				}
				// Now combind the date and time for a new string object
				withInYearTime = new Date(dateString + " " + timeString);			
			} else if((withInYearTime.getFullYear() > currentTime.getFullYear()) &&
				(withInYearTime.getMonth() == currentTime.getMonth()) && 
				(withInYearTime.getDate() == currentTime.getDate()) &&
				(((withInYearTime.getHours() > currentTime.getHours())) ||
				((withInYearTime.getHours() == currentTime.getHours()) &&
				(withInYearTime.getMinutes() > currentTime.getMinutes())) ||
				((withInYearTime.getHours() == currentTime.getHours()) &&
				(withInYearTime.getMinutes() == currentTime.getMinutes()) &&
				(withInYearTime.getSeconds() > currentTime.getSeconds())) )) {
				var dateString;
				var timeString;
				// There is a single year left
				yearCount = 1;
				// Now adjust the withInYearTime to be under one year left
				timeString = formatTwoDigits(withInYearTime.getHours()) + ":" + 
					formatTwoDigits(withInYearTime.getMinutes()) + ":" + 
					formatTwoDigits(withInYearTime.getSeconds());
				// We do not have to worry about leap year since the dates are the same
				dateString = withInYearTime.getDate() + " " + 
					monthNames[withInYearTime.getMonth()] + " " + currentTime.getFullYear();
				// Now combind the date and time for a new string object
				withInYearTime = new Date(dateString + " " + timeString);
			} else {
				// There is no years so we don't need to check again until the
				// time changes
				checkedYear = true;
			}
		} else {
			// There is never years
			checkedYear = true;
		}
	}
	
	var monthsCount = 0;
	var remainingExtra = 0;
	if(checkedMonth == false) {
		var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		// We need to check to see if there are months
		// There could only be months in almost any case so just check them all just to be safe
		// For easier checking convert the months into an increasing number
		var withInMonthCount = (withInYearTime.getFullYear() * 12) + withInYearTime.getMonth();
		var currentMonthCount = (currentTime.getFullYear() * 12) + currentTime.getMonth();
		if((withInMonthCount > (currentMonthCount + 1)) || ((withInMonthCount > currentMonthCount) && 
			(withInYearTime.getDate() > currentTime.getDate())) ) {
			// There are months left
			var dateString;
			var timeString;
			var nextMonth = currentTime.getMonth();
			var currentYear = currentTime.getFullYear();
			var currentDay = withInYearTime.getDate();
			// Compute how many months are left
			if(withInMonthCount == (currentMonthCount + 1)) {
				// We have only one month
				monthsCount = 1;
			} else {
				// Compute the difference in months
				monthsCount = withInMonthCount - currentMonthCount;
				
				// Handle the case that we are into one of those months already
				if(currentTime.getDate() > withInYearTime.getDate()) {
					// The current time is after the date so decrease the month count
					// but increase the next month
					monthsCount--;
					nextMonth++;
				} else if((withInYearTime.getDate() == currentTime.getDate()) &&
					(((currentTime.getHours() > withInYearTime.getHours())) ||
					((currentTime.getHours() == withInYearTime.getHours()) &&
					(currentTime.getMinutes() > withInYearTime.getMinutes())) ||
					((currentTime.getHours() == withInYearTime.getHours()) &&
					(currentTime.getMinutes() == withInYearTime.getMinutes()) &&
					(currentTime.getSeconds() > withInYearTime.getSeconds())) )) {
					// The current time is after the date so decrease the month count
					monthsCount--;
					nextMonth++;
				}
				// Else the date is before the current date so we can use the current year
				// and the year count will stay the same
			}
			// Handle a loop around for the next month
			if(nextMonth == 12) {
				// Move to the next year and January
				nextMonth = 0;
				currentYear++;
			}
			// Check if the current year is a leap year
			if(((currentYear - 2000) % 4) == 0) {
				// It is a leap year so increase the mdays for feb
				mdays[1] = 29;
			}
			// Now adjust the withInYearTime to be under one year left
			timeString = formatTwoDigits(withInYearTime.getHours()) + ":" + 
				formatTwoDigits(withInYearTime.getMinutes()) + ":" + 
				formatTwoDigits(withInYearTime.getSeconds());
			// Handle the case that the next month total days are less then and the withInYearTime date
			if(currentDay > mdays[nextMonth]) {
				// Set the current day to be the last day in the month
				currentDay = mdays[nextMonth];
				// We also want to set the time to be the end of the day
				timeString = "23:59:59";
			}
			// It is not a leap day so use the date like normal
			dateString = currentDay + " " + monthNames[nextMonth] + " " + currentYear;

			// Now combind the date and time for a new string object
			withInYearTime = new Date(dateString + " " + timeString);			
		} else if((withInMonthCount > currentMonthCount) &&
			(withInYearTime.getDate() == currentTime.getDate()) &&
			(((withInYearTime.getHours() > currentTime.getHours())) ||
			((withInYearTime.getHours() == currentTime.getHours()) &&
			(withInYearTime.getMinutes() > currentTime.getMinutes())) ||
			((withInYearTime.getHours() == currentTime.getHours()) &&
			(withInYearTime.getMinutes() == currentTime.getMinutes()) &&
			(withInYearTime.getSeconds() > currentTime.getSeconds())) )) {
			var dateString;
			var timeString;
			// There is a single month left
			monthsCount = 1;
			// Now adjust the withInYearTime to be under one year left
			timeString = formatTwoDigits(withInYearTime.getHours()) + ":" + 
				formatTwoDigits(withInYearTime.getMinutes()) + ":" + 
				formatTwoDigits(withInYearTime.getSeconds());
			// We do not have to worry about leap year or differnet end dates since the dates are the same
			dateString = withInYearTime.getDate() + " " + 
				monthNames[currentTime.getMonth()] + " " + currentTime.getFullYear();
			// Now combind the date and time for a new string object
			withInYearTime = new Date(dateString + " " + timeString);
		} else {
			// There is no months so we don't need to check again until the time changes
			// but this value is only should be set to true if checkedYear is true as well
			checkedMonth = checkedYear;
		}
	}

    // Number of seconds between now and target
    remainingSeconds = Math.floor((withInYearTime.getTime() - currentTime.getTime()) / msPerSecond);
    if ((remainingSeconds <= 0) && (yearCount == 0)) {
        if (wantStopAtZero) {
            remainingSeconds = 0;
        } else {
            remainingSeconds = Math.abs(remainingSeconds);
        }
    }
    
	var leftoverSeconds = remainingSeconds;
	
	// Calculate the extra if we are supposed to
	if(showExtraSetting == "1") {
		// We should compute the weeks
		remainingExtra = Math.floor(remainingSeconds / sPerWeek);
		// And take the remainder
		leftoverSeconds -= (remainingExtra * sPerWeek);
	} else if(showExtraSetting == "2") {
		// Convert the years into months if they are not being shown
		if(showYearsSetting == "0") {
			// There are 12 months in each year
			monthsCount += yearCount * 12;
		}
		// Make sure the remainingExtra is set to just the months count
		remainingExtra = monthsCount;
		// We do not need to change the left over seconds
	}
	var remainingDays = 0;
	// Check if we need to 
	if((showingTimeOnly == false) && (showJustTimeSetting != "0") && (yearCount == 0) && (remainingExtra == 0)) {
		// We are allowed to show just the time, but are not already so check the leftoverSeconds to see
		// if they are less then our show just time thresh hold
		if((goodParseInt(showJustTimeSetting) * sPerHour) > leftoverSeconds) {
			// We should just be showing time only
			showingTimeOnly = true;
			// The seconds are being shown so blink the colon not period
			wantBlinkingColon = true;
			wantBlinkingPeriod = false;	
			// Now setup the display to be in the correct state so that it only shows the time
			layoutTimeOnlyDisplayComponents();
		}
	}
	if(showingTimeOnly == false) {
		// Calculate days since we are still not showing just the time
		remainingDays = Math.floor(leftoverSeconds / sPerDay);
		// And take remainder
		leftoverSeconds -= remainingDays * sPerDay;		
	}

    // Compute the values for hours, minutes, and seconds
    var remainingHours = Math.floor(leftoverSeconds / sPerHour);
    leftoverSeconds -= remainingHours * sPerHour;
    var remainingMinutes = Math.floor(leftoverSeconds / sPerMinute);
    leftoverSeconds -= remainingMinutes * sPerMinute;

    remainingTime[0] = remainingDays;
    remainingTime[1] = remainingHours;
    remainingTime[2] = remainingMinutes;
    remainingTime[3] = leftoverSeconds;
	remainingTime[4] = remainingExtra;
	remainingTime[5] = yearCount;
}

//
// Function: setCountdownTarget(countdownEvent)
// Set the timer's current event to count down to
//
// countdownEvent: object containing eventTime and eventLabel for the event
//
function setCountdownTarget(countdownEvent)
{
	if((showYearsSetting == "1") || (showExtraSetting == "2")) {
		// Reset the checked year and month values if we made it in here then checkedYear
		// shold always be false since month uses that part of the method but checkedMonth
		// depends if months are being shown or not
		checkedYear = false;
		// If this is 2 we want the value to be false else it should be true
		checkedMonth = (showExtraSetting != "2");
	} else {
		// Checked year and month should both be set to true
		checkedYear = true;
		checkedMonth = true;
	}
	// Assume the target has not been reached yet and just time is not showing
	isTargetReached = false;
	showingTimeOnly = false;
    countdownTarget = countdownEvent;
    if (countdownEvent.eventLabel != null) {
        setEventLabel(countdownEvent.eventLabel);
    }
	// Now make sure that the display components are setup correctly
	layoutDisplayComponents();
}

//
// Function: setNextCountdownTarget()
// Find the next event in the event list and set the timer
//
function setNextCountdownTarget()
{
	var newDateTimeStr = null;
	var targetTime = countdownTarget.eventTime;
	var curDate = null;
    
	updateCurrentTime();
	curDate = currentTime;
	
	// Check if it is the next day or in the future of our current event time
	if((curDate.getFullYear() > targetTime.getFullYear()) || 
		(curDate.getMonth() > targetTime.getMonth()) ||
		(curDate.getDate() > targetTime.getDate())) {
		// It is time to compute a new countdown target
		var monthNames = [ "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", 
			"Sept", "Oct", "Nov", "Dec" ];
		var timeString;
		var dateString;
		// Setup the time string now so we can use it later
		timeString = formatTwoDigits(targetTime.getHours()) + ":" +
			formatTwoDigits(targetTime.getMinutes()) + ":" +
			formatTwoDigits(targetTime.getSeconds());

		// The Handle the repeat cases
		if(repeatSetting == 1) {
			// Yearly
			// This case gets complicated for leap years on Feburary but are otherwise
			// pretty simple
			var day = goodParseInt(daySetting) + 1;
			var monthVal = targetTime.getMonth();
			var yearVal = curDate.getFullYear();
			if(monthVal == 1) {
				// It set for feburary so compute the day
				if(daySetting == 31) {
					// The value should be the last day of the year
					// By default the last day should be 28
					day = 28;
					// Check if this is is a leap year
					if(((yearVal - 2000) % 4) == 0) {
						// It is a leap year so the last day is 29
						day = 29;
					}
					// We know the year is equal to the current dates year at this point
					if(monthVal < curDate.getMonth()) {
						// We are past the current date found so we need to move to the next year
						yearVal++;
						// Check if this year is a leap year
						if(((yearVal - 2000) % 4) == 0) {
							// It is a leap year so the last day is 29
							day = 29;
						} else {
							// It is not a leap year so the day is 28
							day = 28;
						}
					}
				} else if(daySetting == 28) {
					// This is day 29 which only is for leap years so find the right year
					// Check if this is is a leap year
					if((((yearVal - 2000) % 4) == 0) && (monthVal < curDate.getMonth())) {
						// This year is a leap year but we have already passed the month
						// So we need to go to the next leap year
						yearVal += 4;
					} else if(((yearVal - 2000) % 4) != 0) {
						// The current year is not a leap year so we need to go to the next 
						// leap year
						yearVal += (4 - ((yearVal - 2000) % 4));
					}
				}
			}
			// Check if it is past the current day set
			if((yearVal == curDate.getFullYear()) && ((monthVal < curDate.getMonth()) || 
				((monthVal == curDate.getMonth()) && (day < curDate.getDate())))) {
				// We are past the current date found so we need to move to the next year
				yearVal++;
			}
			// We have our date so create the string
			dateString = day + " " + monthNames[monthVal] + " " + yearVal;
		} else if(repeatSetting == 2) {
			// Montly
			// This is pretty straight forward but there can be complications for days over
			// the 28th and the day setting of 31 (Last)
			var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
			var day = goodParseInt(daySetting) + 1;
			var monthVal = curDate.getMonth();
			var yearVal = curDate.getFullYear();
			// Check if it is a leap year
			if(((yearVal - 2000) % 4) == 0) {
				// It is a leap year so increase the feburay day count to 29
				mdays[1] = 29;
			}
			if(daySetting == 31) {
				// The day setting is for the last day of the month
				day = mdays[monthVal];
			}
			// Check if it is past the current day set
			if((day < curDate.getDate()) || (day > mdays[monthVal])) {
				// We are past the current day of the month so we need to move to the next month
				do {
					// Increase to the next month
					monthVal++;
					// There is no reason to check for a loop around because December has
					// the max number of days so if it is 31 we would never get here
				} while(day > mdays[monthVal]);
			}
			// We have our date so create the string
			dateString = day + " " + monthNames[monthVal] + " " + yearVal;
		} else if(repeatSetting == 3) {
			// Weekly
			// This needs to handle moving to the next week if we are past that day for this week
			var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
			var day = curDate.getDate();
			var dayVal = curDate.getDay();
			var monthVal = curDate.getMonth();
			var yearVal = curDate.getFullYear();
			var daysForward = 0;
			// Check if it is a leap year
			if(((yearVal - 2000) % 4) == 0) {
				// It is a leap year so increase the feburay day count to 29
				mdays[1] = 29;
			}
			// Check if we are past the current day of the week
			if(dayVal > daySetting) {
				// We need to move to the next week
				// The first part tells how many days to get to the end of the week
				// The second part tells how many days to get to the right day or the week
				daysForward = (6 - dayVal) + goodParseInt(daySetting) + 1;
			} else if(dayVal < daySetting) {
				// We need to move forward to the right day
				daysForward = daySetting - dayVal;
			}
			if(daysForward > 0) {
				// Move forward by the given amount of days
				day += daysForward;
				// Check for wrap around
				if(day > mdays[monthVal]) {
					// Wrap the days around for this month
					day = day - mdays[monthVal];
					// Increase the month
					monthVal++;
					// Check for year wrap around
					if(monthVal >= 12) {
						// Move to the next year and reset the month
						yearVal++;
						monthVal = 0;
					}
				 } 
			}
			// We have our date so create the string
			dateString = day + " " + monthNames[monthVal] + " " + yearVal;
		} else if(repeatSetting == 4) {
			// Daily
			// This is very simple and should be the current day month and year with no exceptions
			var day = curDate.getDate();
			var monthVal = curDate.getMonth();
			var yearVal = curDate.getFullYear();
			// We have our date so create the string
			dateString = day + " " + monthNames[monthVal] + " " + yearVal;
		} else if(repeatSetting == 5) {
			// Weekdays
			// This is straight forward if it is already a weekday else we need to move back to 
			// the past Friday so the timer is sure to be stopped
			var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
			var day = curDate.getDate();
			var dayVal = curDate.getDay();
			var monthVal = curDate.getMonth();
			var yearVal = curDate.getFullYear();
			var daysBackward = 0;
			// Check if it is a leap year
			if(((yearVal - 2000) % 4) == 0) {
				// It is a leap year so increase the feburay day count to 29
				mdays[1] = 29;
			}
			// Check if we on the week end
			if(dayVal == 0) {
				// It is Sunday so move back one week
				daysBackward = 2;
			} else if(dayVal == 6) {
				// It is Saturday so move back to Friday
				daysBackward = 1;
			}
			if(daysBackward > 0) {
				// Move backward by the given amount of days
				day -= daysBackward;
				// Check for going to the previus month
				if(day < 1) {
					// Decrease the month
					monthVal--;		
					// Check for year wrap around
					if(monthVal < 0) {
						// Move to the past year and set the month to December
						yearVal--;
						monthVal = 11;
					}					
					// Wrap the days around for this month
					day = mdays[monthVal] + day;
				 } 
			}
			// We have our date so create the string
			dateString = day + " " + monthNames[monthVal] + " " + yearVal;
		} else if(repeatSetting == 6) {
			// Weekend days
			// This is straight forward if it is already a weekend day else we need to move back to 
			// the past Sunday so the timer is sure to be stopped
			var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
			var day = curDate.getDate();
			var dayVal = curDate.getDay();
			var monthVal = curDate.getMonth();
			var yearVal = curDate.getFullYear();
			var daysBackward = 0;
			// Check if it is a leap year
			if(((yearVal - 2000) % 4) == 0) {
				// It is a leap year so increase the feburay day count to 29
				mdays[1] = 29;
			}
			// Check if we are not a weekend day
			if((dayVal != 0) && (dayVal != 6)) {
				// It not a weekend days so move back to Sunday
				daysBackward = dayVal;
			}
			if(daysBackward > 0) {
				// Move backward by the given amount of days
				day -= daysBackward;
				// Check for going to the previus month
				if(day < 1) {
					// Decrease the month
					monthVal--;		
					// Check for year wrap around
					if(monthVal < 0) {
						// Move to the past year and set the month to December
						yearVal--;
						monthVal = 11;
					}					
					// Wrap the days around for this month
					day = mdays[monthVal] + day;
				 } 
			}
			// We have our date so create the string
			dateString = day + " " + monthNames[monthVal] + " " + yearVal;
		}  else if(repeatSetting == 7) {
            // Advanced Yearly
            // We need to compute the next yearly repeat for the target time year + 1
            var newDate = getDateForDayOfWeekInMonth(targetTime.getMonth(), targetTime.getFullYear() + 1, daySetting, 
                repeatExtraSetting);
            
            // Now set this date object to be the date string
            dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();           
        }  else if(repeatSetting == 8) {
            // Advanced Monthly
            // We need to compute the next month repeat for the target time month + 1 taking into account wrap around
            var monthVal = targetTime.getMonth() + 1;
            var yearVal = targetTime.getFullYear();
            if(monthVal == 12) {
                // Wrap the month around back to January and increase the year
                monthVal = 0;
                yearVal++;
            }
            var newDate = getDateForDayOfWeekInMonth(monthVal, yearVal, daySetting, repeatExtraSetting);
            
            // Now set this date object to be the date string
            dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();           
        } else if(repeatSetting == 9) {
            // Advanced Weekly
            // We just need to take the current target time and increase it by a set amount of weeks
            // to get the new date string
            var newDate = new Date();
            newDate.setTime(targetTime.getTime());
            // We need to set the hours to 12 so that the day switch does not cause a day change because of DLST
            // plus we do not care about the time part of the date
            newDate.setHours(12);
            // Now increase the date by the set amount of weeks
            newDate.setTime(newDate.getTime() + (repeatExtraSetting * sPerWeek * 1000));
            // Now set this date object to be the date string
            dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();
        } else if(repeatSetting == 10) {
            // Advanced Daily
            // We just need to take the current target time and increase it by a set amount of days
            // to get the new date string
            var newDate = new Date();
            newDate.setTime(targetTime.getTime());
            // We need to set the hours to 12 so that the day switch does not cause a day change because of DLST
            // plus we do not care about the time part of the date
            newDate.setHours(12);
            // Now increase the date by the set amount of days
            newDate.setTime(newDate.getTime() + (repeatExtraSetting * sPerDay * 1000));
            // Now set this date object to be the date string
            dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();
        }
		
		// Handle the special case of the event using iCal repeats
		if(repeatSetting == 20) {
			// iCal Repeat
			var nextTime = findNextEventOccurance();
			if(nextTime != null) {
				// The next date for this repeating event exits and so use it
				newDateTimeStr = nextTime;
			} else {
				// There are not repeats so set the repeatSetting to none
				repeatSetting = 0;
				// Remove the iCal repeat item from the popup and update the repeat value
				var repeatPopup = document.getElementById("Repeat_popup");
				if(repeatPopup[repeatPopup.length - 1].text == iCalRepeatItemText) {
					repeatPopup.remove(repeatPopup.length - 1);
				}
				repeatSetting = 0;
				repeatPopup.value = 0;
			}
		} else {
			// Create the new date time string
			newDateTimeStr = dateString + " " + timeString;
		}
	}
    
    if ((newDateTimeStr != null) && (countdownStringSetting != newDateTimeStr)) {
        // Check to see if there is a repeat until value set
        var cancelRepeat = false;
        if((repeatUntilSetting != null) && (repeatUntilSetting.length > 0)) {
            // There is a repeat until value so check to see if it should be canceled
            var nextDate = new Date(newDateTimeStr);
            var repeatUntilDate = new Date(repeatUntilSetting + " 23:59:59");
            // Check if repeat date comes earlier then the 
            if(repeatUntilDate.getTime() < nextDate.getTime()) {
                // The repeat until date has been passed so cancel repeating
                cancelRepeat = true;
            }
        }
        if(cancelRepeat) {
            // The repeat should be canceled
            repeatSetting = 0;
            repeatUntilSetting = "";
        } else {
            // Set this string as the new event time
            countdownStringSetting = newDateTimeStr;
            // Use the settings then save them
            useSettings();
            saveProperties();
        }
    }
}

//
// Function: startDisplayUpdateTimer()
// Start the interval timer to update the countdown once a second
//
function startDisplayUpdateTimer()
{
    updateTimerDisplay();

    if (!updateTimerDisplayInterval)
        updateTimerDisplayInterval = setInterval(updateTimerDisplay, 1000);
}

//
// Function: stopDisplayUpdateTimer()
// Remove the interval timer
//
function stopDisplayUpdateTimer()
{
    if (updateTimerDisplayInterval) {
        clearInterval(updateTimerDisplayInterval);
        updateTimerDisplayInterval = null;
    }
}

/**
This is the callback when either the left or right images on the front are
clicked by the user. If the link feature is turned on with a valid link then
this will go to the links website
*/
function frontImageClicked() {
	handleFrontImagesClicked();
}

//
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
	// Make sure the web templates are not loaded yet
	webYearTemplatesLoaded = false;
	webMiscTemplatesLoaded = false;
    setupParts();
	
	changingTemplate = false;

    // Get the properties
    targetKind         = attributes.targetKind;
    wantLeadingZeros   = attributes.showLeadingZeros == 1;
    wantBlinkingColon  = attributes.blinkSeparators == 1;
    wantStopAtZero     = attributes.reachedActionIndex == 0;
    doAction           = attributes.doAction == 1;
    zeroAction         = attributes.zeroAction;
    iCalEventSummary   = attributes.iCalEventSummary;
    sharediCalURL      = attributes.sharediCalURL;
	
	// Setup the year and month properties
	checkedYear = false;
	checkedMonth = false;
	showingTimeOnly = false;
	
	// Make sure the image data is loaded
	setupImageDataArray();
						 
	// Load the properties from the widget
	loadProperties();
	// Now that properties are loaded set the countdown target
    setCountdownTarget({ eventTime: new Date(countdownStringSetting),
                         eventLabel: eventTitleSetting });

	// Just start the timer now
	startDisplayUpdateTimer();
	
	// Make sure the time and appearance components are setup correctly
	timeButtonPressed();
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
    stopDisplayUpdateTimer();
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
	// Stop timer to prevent CPU usage
    stopDisplayUpdateTimer();
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
	// Re-start timer
    startDisplayUpdateTimer();
}

//
// Function: sync()
// Called when the widget has been synchronized with .Mac
//
function sync()
{
	wantStopAtZero     = false;
    // Retrieve any preference values that you need to be synchronized here
	// Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");    
}



// This will work better then parseInt because parseInt does not parse
// 08 and 09 correctly
// str:String the string to parse into an int value
// return: An integer that was parsed from the string
function goodParseInt(str) {
	var ret = 0;
	// Handle the cases where parseInt doesn't work
	if((str.charAt(0) == "0") && (str.length > 1)) {
		// It starts with 0 so remove the zero and parse the int
		ret = parseInt(str.substring(1));
	} else  {
		// Call parse int on the string since it does not start with 0
		ret = parseInt(str);
	}
	return ret;
}

/**
This method is called when the cancel button is pressed. It is like the done
button but nothing will be saved
*/
function showFrontCancel(event) {
	// Make sure the iCal checkbox stays in the right state
	var icalCheck = document.getElementById("iCal_checkbox_check");
	if(icalCheck.checked != (usingICalTemplateSetting && iCalPluginUsable)) {
		// The check box changed states so change it back
		icalCheck.checked = !(icalCheck.checked);
		fillTemplate1();
	}
	// Call showFront to do all the rest of the work
	showFront(event);
}

/**
This method is called when the done button is pressed. It is like the cancel
button but the properties setup will be propogated to the countdown timer and
will also be saved
*/
function showFrontDone(event) {
	// Create and save all the properties from the back panel
	// since done has been pressed
	convertBackToSettings();
	useSettings();
	saveProperties();
	
	// Call showFront to do most of the work
	showFront(event);
}

//
// Function: showFront(event)
// Called when the done button is clicked from the back of the widget
//
// event: onClick event from the done button
//
function showFront(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
	}

    front.style.display="block";
    back.style.display="none";

    //startDisplayUpdateTimer();
    
    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
	}
}

// Initialize the Dashboard event handlers
if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    widget.onsync = sync;
}
