// This file is used to handle the events and hiding/showing of the time specific components
// on the back side of the widget

/**
This function will be called when the Time button on the back of the widget
has been clicked. This will cause the time specific components to show while
the appearance specific components will be hidden
*/
function timeButtonPressed() {
	// Make the appearance specific components invisible while the time ones are visible
	setAppearanceComponentsVisibility(false);
	setTimeComponentsVisibility(true);
	
	// Make the time button disabled now that we are on that part of the widget
	document.getElementById("To_time").object.setEnabled(false);
	// The appearance button should be enabled
	document.getElementById("To_appearance").object.setEnabled(true);
}

/**
This function will set all the time specific components visibility to correspond to the value 
passed into this method
vis:Boolean If the components should be visible or not true for visible false for invisible
*/
function setTimeComponentsVisibility(vis) {
	// Assume by default that vis is true
	var visStr = "visible";
	if(vis == false) {
		// Since vis is really false we need to set the string to hidden instead
		visStr = "hidden";
	}
	
	// First hide the template componets
	document.getElementById("Template_label").style.visibility = visStr;
	document.getElementById("Template1_popup").style.visibility = visStr;
	document.getElementById("Template2_popup").style.visibility = visStr;
	document.getElementById("Reload_button").style.visibility = visStr;
	// The iCal checkbox needs to be hidden specially
	if((vis) && (iCalPluginUsable == false)) {
		// The checkbox should be hidden always
		document.getElementById("iCal_checkboxbutton").style.visibility = "hidden";
	} else {
		// The checkbox should have the default setting
		document.getElementById("iCal_checkboxbutton").style.visibility = visStr;
	}
	// Next hide the event title componets
	document.getElementById("EventTitle_label").style.visibility = visStr;
	document.getElementById("EventTitle_textfield").style.visibility = visStr;
	// Now hide the date popup and labels
	document.getElementById("Month_popup").style.visibility = visStr;
	document.getElementById("Day_popup").style.visibility = visStr;
	document.getElementById("Year_popup").style.visibility = visStr;
	document.getElementById("Month_label").style.visibility = visStr;
	document.getElementById("Day_label").style.visibility = visStr;
	document.getElementById("Year_label").style.visibility = visStr;
	// Next hide the time popup and labels
	document.getElementById("Hour_popup").style.visibility = visStr;
	document.getElementById("Minute_popup").style.visibility = visStr;
	document.getElementById("Second_popup").style.visibility = visStr;
	document.getElementById("AMPM_popup").style.visibility = visStr;
	document.getElementById("Hour_label").style.visibility = visStr;
	document.getElementById("Minute_label").style.visibility = visStr;
	document.getElementById("Second_label").style.visibility = visStr;
	// Finally hide the repeat components
	document.getElementById("Repeat_label").style.visibility = visStr;
	document.getElementById("Repeat_popup").style.visibility = visStr;
	document.getElementById("Repeat_Until_popup").style.visibility = visStr;
	// The visiblity of the repeat date popups should only be set to visible if the until popup is of value 1
	if((vis) && (document.getElementById("Repeat_Until_popup").value == 1)) {
		// Set the repeat date popups to the visible setting
		document.getElementById("Repeat_Month_popup").style.visibility = visStr;
		document.getElementById("Repeat_Day_popup").style.visibility = visStr;
		document.getElementById("Repeat_Year_popup").style.visibility = visStr;
	} else {
		// Set the repeat date popups all to hidden
		document.getElementById("Repeat_Month_popup").style.visibility = "hidden";
		document.getElementById("Repeat_Day_popup").style.visibility = "hidden";
		document.getElementById("Repeat_Year_popup").style.visibility = "hidden";
	}
    // The visiblity of the repeat extra components should only be set to visible if the repeat popup is visible
    // and is set to an advanced setting
    var repeatVal = document.getElementById("Repeat_popup").value
    if((vis) && ((repeatVal == 7) || (repeatVal == 8) || (repeatVal == 9) || (repeatVal == 10))) {
        // The repeat extra components should be set to the visible setting
        document.getElementById("Repeat_Extra_label").style.visibility = visStr;
		document.getElementById("Repeat_Extra_popup").style.visibility = visStr;
    } else {
        // The repeat extra components should be set to the hidden
        document.getElementById("Repeat_Extra_label").style.visibility = "hidden";
		document.getElementById("Repeat_Extra_popup").style.visibility = "hidden";    
    }
}

/**
This will add the values 00, 01, 02, ..., 58, 59 to the popup button
with the given id passed into the is method as
elementid:String the id of the popup button to populate
*/
function initZeroTo59(elementid) {
	// Get the Minute popup menu
	var popup = document.getElementById(elementid);
	if(popup.length < 2) {
		// The element has not been initialized yet
		// Loop until the popup menu is empty
		while(popup.length > 0) {
			// Remove the last value
			popup.remove(popup.length - 1);
		}
		//popup.disabled = true;
		// Now add the values 00 to 59
		for(var i = 0; i < 60; i++) {
			popup.appendChild(new Option(formatTwoDigits(i), i));
		}
	}
}

/**
This method will initialize all the popup buttons so that they
all have their initial values popuplated like the other boxes do
*/
function initPopupBoxes() {
	// Initialize the image popup box
	fillImagePopup();
	// Initialize the minutes and seconds popup menu
	initZeroTo59("Minute_popup");
	initZeroTo59("Second_popup");
	// Initialize the year and repeat year popup boxes to contain 100 years
	var yearPopup = document.getElementById("Year_popup");
    var repeatYearPopup = document.getElementById("Repeat_Year_popup");
	if(yearPopup.length < 2) {
		// The year popup has not been initialized yet so clear it first
		// Loop until the popup menu is empty
		while(yearPopup.length > 0) {
			// Remove the last value
			yearPopup.remove(yearPopup.length - 1);
		}
        // Do the same for the repeat popup
        while(repeatYearPopup.length > 0) {
			// Remove the last value
			repeatYearPopup.remove(repeatYearPopup.length - 1);
		}
		// Get the current year
		var curYear = currentTime.getFullYear();
		// Now add 100 years to the current year
		for(var i = 0; i < 100; i++) {
			yearPopup.appendChild(new Option(curYear + i, curYear + i));
            repeatYearPopup.appendChild(new Option(curYear + i, curYear + i));
		}
	}
}

/**
This is called when the year popup box changes value
event:Event The event will not be null if the action was caused by the user
*/
function yearPopupChange(event) {
	// Get the month value
	var monthValue = document.getElementById("Month_popup").value;
	if(monthValue == 1) {
		// The month is Feburary so update the day popup
		updateDayPopup();
	}
	// Make sure the template is updated
	if(event != null) {
		// The action was caused by the user so call the iCal enabled edit method
		handleTemplateEdit();
	} else {
		// The action was not caused by the user so do the correct call
		templateEdit();
	}
}

/**
This will handle setting the values for the day popup box
event:Event The event will not be null if the action was caused by the user
*/
function updateDayPopup(event) {
	// Get the day popup
	var dayPop = document.getElementById("Day_popup");
	var dayValue = dayPop.value;
	if((dayPop.disabled) && (document.getElementById("Repeat_popup").value != 20)) {
		// The popup is disabled so make sure there is only one option
		if(dayPop.length != 1) {
			// Remove all values from the popup
			while(dayPop.length > 0) {
				// Remove the last value
				dayPop.remove(dayPop.length - 1);
			}
			// Now add 1 as the only value to the popup
			dayPop.appendChild(new Option("1", 1));
		}
		// Else the popup already has one item 
	} else {
		// First get the repeat value
		var repeatValue = document.getElementById("Repeat_popup").value;
		var weekdays = (dayPop.length == 7);
		// When the popup box is not disabled the repeat value can be
		// Never, Yearly, Montly, or weekly
		// First clear all values from the popup
		while(dayPop.length > 0) {
			// Remove the last value
			dayPop.remove(dayPop.length - 1);
		}
		if((repeatValue == 3) || (repeatValue == 7) || (repeatValue == 8) || (repeatValue == 9)) {
			// Weekly
            // Also Advanced Yearly, Montly and Weekly
			// The values should be days of the week
			dayPop.appendChild(new Option("Sun", 0));
			dayPop.appendChild(new Option("Mon", 1));
			dayPop.appendChild(new Option("Tue", 2));
			dayPop.appendChild(new Option("Wed", 3));
			dayPop.appendChild(new Option("Thu", 4));
			dayPop.appendChild(new Option("Fri", 5));
			dayPop.appendChild(new Option("Sat", 6));
			if(weekdays) {
				// Keep the same value as before
				dayPop.value = dayValue;
			} else {
				// Set the day value to be 0 which is Sunday
				dayPop.value = 0;
			}
		} else if(repeatValue == 2) {
			// Monthly
			// The values should be 1-31 with a Last as the final option
			for(var i = 0; i < 31; i++) {
				// Add i + 1 to as an option
				dayPop.appendChild(new Option((i + 1), i));
			}
			// Now add Last as the final option
			dayPop.appendChild(new Option("Last", 31));
			if(weekdays == false) {
				// Keep the same value as before
				dayPop.value = dayValue;
			}
		} else {
			// Never, Yearly, iCal repeat
			// The values depend on the current month so get its value
			var monthValue = document.getElementById("Month_popup").value;
			var mdays = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
			if((repeatValue == 0) && (monthValue == 1)) {
				// It is Never and Febuary so check for leap year
				var yearValue = document.getElementById("Year_popup").value;
				if(((yearValue - 2000) % 4) != 0) {
					// It is a not a leap year so reduce the months days to 28
					mdays[1] = 28;
				}
			}
			var endDay = mdays[monthValue];
			for(var i = 0; i < endDay; i++) {
				// Add i + 1 to as an option
				dayPop.appendChild(new Option((i + 1), i));
			}
			if((monthValue == 1) && (repeatValue == 1)) {
				// It is Febuary Yearly so last should be a choice as well
				dayPop.appendChild(new Option("Last", 31));
				if((weekdays == false) && (dayValue == 31)) {
					// Keep the same value as before
					dayPop.value = dayValue;
				} else if((weekdays == false) && (dayValue < dayPop.length)) {
					// Keep the same value as before
					dayPop.value = dayValue;
				} else {
					// Set the value to be 0 which is 1
					dayPop.value = 0;
				}
			} else if(weekdays == false) {
				// Try to keep the same value as before
				if(dayValue >= dayPop.length) {
					// Cap the value at the lenght - 1
					dayValue = dayPop.length - 1;
				}
				// Set the same value as before
				dayPop.value = dayValue;
			} else {
				// Set the value to be 0 or 1
				dayPop.value = 0;
			}
		}
	}
	// Make sure the template is updated
	if(event != null) {
		// The action was caused by the user so call the iCal enabled edit method
		handleTemplateEdit();
	} else {
		// The action was not caused by the user so do the correct call
		templateEdit();
	}
}

/**
This method will enable or disable the month day and year popup
boxes depending on the value of the repeat popup
event:Event The event passed in by the caller or undefined if none was passed in
*/
function handleRepeatValue(event) {
	// Get the repeat popups value
	var repeatValue = document.getElementById("Repeat_popup").value;
	// Get the month day and year popups
	var monthPop = document.getElementById("Month_popup");
	var dayPop = document.getElementById("Day_popup");
	var yearPop = document.getElementById("Year_popup");
    // Get the repeat until popup
    var repeatUntilPop = document.getElementById("Repeat_Until_popup");
    // By default the repeat until popup should be enabled
    repeatUntilPop.disabled = false;
    if(event == null) {
        // The repeat value should also change back to forever by default
        repeatUntilPop.value = 0;
        repeatUntilDatePopupChanged(event);
    }
	if(repeatValue == 0) {
		// Never
		// The month day and year popups should be enabled
		monthPop.disabled = false;
		dayPop.disabled = false;
		yearPop.disabled = false;
        // The repeat until popup should be disabled and have a value of 0 for this case
        repeatUntilPop.value = 0;
        repeatUntilPop.disabled = true;
        repeatUntilDatePopupChanged(event);
	} else if((repeatValue == 1) || (repeatValue == 7)) {
		// Yearly and Advanced Yearly
		// The year should be disabled
		monthPop.disabled = false;
		dayPop.disabled = false;
		yearPop.disabled = true;
	} else if((repeatValue == 2) || (repeatValue == 8)) {
		// Monthly and Advanced Montly
		// The year and month should be disabled
		monthPop.disabled = true;
		dayPop.disabled = false;
		yearPop.disabled = true;
	} else if((repeatValue == 3) || (repeatValue == 9)) {
		// Weekly and Advanced Weekly
		// The year and month should be disabled
		monthPop.disabled = true;
		dayPop.disabled = false;
		yearPop.disabled = true;
	} else if((repeatValue == 4) || (repeatValue == 5)  || (repeatValue == 6) || (repeatValue == 10)) {
		// Daily, Weekdays, Weekend days and Advanced Daily
		// The year, month and day should be disabled
		monthPop.disabled = true;
		dayPop.disabled = true;
		yearPop.disabled = true;
	}
    
    // Now handle the setup of the repeat extra components
    if((repeatValue == 7) || (repeatValue == 8) || (repeatValue == 9) || (repeatValue == 10)) {
        var extraPopup = document.getElementById("Repeat_Extra_popup");
        // Clear the popup of all its items
        while(extraPopup.length > 0) {
            // Remove the last value
            extraPopup.remove(extraPopup.length - 1);
        }
        // The extra components should be setup to the correct value
        if((repeatValue == 7) || (repeatValue == 8)) {
            // The label should say Day Occurrence
            document.getElementById("Repeat_Extra_label").innerHTML = "Day Occurrence";
            // Add the five items to the popup
            extraPopup.appendChild(new Option("First", 1));
            extraPopup.appendChild(new Option("Second", 2));
            extraPopup.appendChild(new Option("Third", 3));
            extraPopup.appendChild(new Option("Forth", 4));
            extraPopup.appendChild(new Option("Last", 5));
        } else {
            // The label should say Repeat Every
            document.getElementById("Repeat_Extra_label").innerHTML = "Repeat Every";
            // Get the repeat string and default to weeks
            var repeatString = " Weeks";
            if(repeatValue == 10) {
                // The string should be days instead
                repeatString = " Days";
            }
            // Now add 2-50 items into the popup
            for(var i = 2; i <= 50; i++) {
                extraPopup.appendChild(new Option(i + repeatString, i));
            }
        }
        // Set the visiblity of the extra components to match the repeat popup
        extraPopup.style.visibility = document.getElementById("Repeat_popup").style.visibility;
        document.getElementById("Repeat_Extra_label").style.visibility = extraPopup.style.visibility;
    } else {
        // The extra components should be hidden
        document.getElementById("Repeat_Extra_label").style.visibility = "hidden";
		document.getElementById("Repeat_Extra_popup").style.visibility = "hidden";  
    }
    
	if(repeatValue != 20) {
		// Make sure the time popups are enabled
		document.getElementById("Hour_popup").disabled = false;
		document.getElementById("Minute_popup").disabled = false;
		document.getElementById("Second_popup").disabled = false;
		document.getElementById("AMPM_popup").disabled = false;		
	} else {
		// All popups should be disabled for the iCal Repeat option
		monthPop.disabled = true;
		dayPop.disabled = true;
		yearPop.disabled = true;
		// Disable all the time popups
		document.getElementById("Hour_popup").disabled = true;
		document.getElementById("Minute_popup").disabled = true;
		document.getElementById("Second_popup").disabled = true;
		document.getElementById("AMPM_popup").disabled = true;
        // The repeat until popup should be disabled and have a value of 0 for this case
        repeatUntilPop.value = 0;
        repeatUntilPop.disabled = true;
        repeatUntilDatePopupChanged(event);      
	}
	// Make sure the day popup is updated
	// This will also update the template
	updateDayPopup();
	
	// Check if an iCal event is being used and it is a user based value change
	if((event != null) && (document.getElementById("iCal_checkbox_check").checked)) {
		// iCal is being used and the user changed the repeat value
		changeiCalTemplateBackToNone();
	}	
}

/**
This is called when the reload button is pressed by the user. It will reload the current template
selected which is either the current iCal calendar or the current web template
*/
function handleReloadButton() {
	// Check if the iCal button is checked
	if(document.getElementById("iCal_checkbox_check").checked) {
		// The iCal button is checked so handle the calander reload
		reloadICalEvents();
	} else {
		// The iCal button is not checked so handle the web template reload
		reloadWebTemplate();
	}
}

/**
This will be called when the repeat popup changes its value and the repeat date popups need to have
there visiblity set
event:Event this will be not null if the method call was caused by the user
*/
function repeatUntilDatePopupChanged(event) {
	// Assume the value for the repeat popups to be visible by default
	var visStr = "visible";
	// Get the new value of the 
	if((document.getElementById("Repeat_Until_popup").value == 0) || 
        (document.getElementById("Repeat_Until_popup").style.visibility == "hidden")) {
		// The repeat date popups all should be hidden
		visStr = "hidden";
	}	
	// Set the visiblity state of all the repeat date popus
	document.getElementById("Repeat_Month_popup").style.visibility = visStr;
	document.getElementById("Repeat_Day_popup").style.visibility = visStr;
	document.getElementById("Repeat_Year_popup").style.visibility = visStr;
    if(event != null) {
        // The event was caused by the user so change the template
        handleTemplateEdit();
        if(document.getElementById("Repeat_Until_popup").value == 1) {
            // The date until popup were made visible so set their value
            var curDate = new Date();
            setRepeatUntilDatePopupValue(11, 30, curDate.getFullYear() + 1);
        }
    }
}

/**
This is called when the repeat year popup box changes value
event:Event The event will not be null if the action was caused by the user
*/
function yearRepeatPopupChange(event) {
	// Get the repeat month value
	var monthValue = document.getElementById("Repeat_Month_popup").value;
	if(monthValue == 1) {
		// The month is Feburary so update the day popup
		updateRepeatDayPopup();
	}
	// Make sure the template is updated
	if(event != null) {
		// The action was caused by the user so call the iCal enabled edit method
		handleTemplateEdit();
	} else {
		// The action was not caused by the user so do the correct call
		templateEdit();
	}
}

/**
This will handle setting the values for the day popup box
event:Event The event will not be null if the action was caused by the user
*/
function updateRepeatDayPopup(event) {
	// Get the repeat day popup and its value
	var dayPop = document.getElementById("Repeat_Day_popup");
	var dayValue = dayPop.value;

    // First clear all values from the popup
    while(dayPop.length > 0) {
        // Remove the last value
        dayPop.remove(dayPop.length - 1);
    }

    // Never, Yearly, iCal repeat
    // The values depend on the current month so get its value
    var monthValue = document.getElementById("Repeat_Month_popup").value;
    var mdays = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    if(monthValue == 1) {
        // It is Febuary so check for leap year
        var yearValue = document.getElementById("Repeat_Year_popup").value;
        if(((yearValue - 2000) % 4) != 0) {
            // It is a not a leap year so reduce the months days to 28
            mdays[1] = 28;
        }
    }
    var endDay = mdays[monthValue];
    for(var i = 0; i < endDay; i++) {
        // Add i + 1 to as an option
        dayPop.appendChild(new Option((i + 1), i));
    }
    
    // Try to keep the same value as before
    if(dayValue >= dayPop.length) {
        // Cap the value at the lenght - 1
        dayValue = dayPop.length - 1;
    }
    // Set the same value as before
    dayPop.value = dayValue;

	// Make sure the template is updated
	if(event != null) {
		// The action was caused by the user so call the iCal enabled edit method
		handleTemplateEdit();
	} else {
		// The action was not caused by the user so do the correct call
		templateEdit();
	}
}

/**
This method will set the repeat until popup to be the right value based on the dateStr
passed in along with setting the until date popups
dateStr:String The date part of a string to use for setting the repeat until date popups or
   a null or empty string for the repeat until popup value to be set to forever
*/
function setRepeatUntilPopupValue(dateStr) {
    if((dateStr == null) || (dateStr.length == 0)) {
        // The date is not valid so set the popup to forever
        document.getElementById("Repeat_Until_popup").value = 0;
    } else {
        // The date is valid so set the popup to until after date
        document.getElementById("Repeat_Until_popup").value = 1;
        // Create a date object for this string
        var dateObj = new Date(dateStr + " 00:00:00");
        // Set the date popup values
        setRepeatUntilDatePopupValue(dateObj.getMonth(), dateObj.getDate() - 1, dateObj.getFullYear());
    }
    // Now make sure the popup is updated
    repeatUntilDatePopupChanged();
}

/**
This will set the repeat until date popups to the values passed in
month:Number The zero based month to set the month popup to
day:Number The zero based day of the month to set the day popup to
year:Number The year to set the year popup to
*/
function setRepeatUntilDatePopupValue(month, day, year) {
    // Set the month and year values first
    document.getElementById("Repeat_Month_popup").value = month;
    document.getElementById("Repeat_Year_popup").value = year;
    // Now make sure the day popup is initilazed correctly
    updateRepeatDayPopup();
    // Now set the day value
    document.getElementById("Repeat_Day_popup").value = day;
}

/**
This will get the date string for the repeat until popups
return: String which is an empty string for Forever and the date of the date popups if it is Until After Date
*/
function getRepeatUntilPopupValue() {
    var dateStr = "";
    
    // Check if it is Until After Date
    if(document.getElementById("Repeat_Until_popup").value == 1) {
        // Convert the repeat until date popups into a string
        var monthNames = [ "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", 
            "Sept", "Oct", "Nov", "Dec" ];
        dateStr = (goodParseInt(document.getElementById("Repeat_Day_popup").value) + 1) + " " + 
            monthNames[document.getElementById("Repeat_Month_popup").value] + " " + 
            document.getElementById("Repeat_Year_popup").value;
    }
    
    // Return the date string that was created
    return dateStr;
}

/**
This will compute and return a Date object for the day of the week for the given parameters passed in
month:Number or String the month of the Date object to create in the range of 0-11
year:Number or String the year of the Date object to create
dayOfWeek:Number or String the day of the week to compute the day occurrence for with range 0-6 (Sun-Sat)
dayOccurrence:Number or String the occurrence of the day of the week to compute with range 1-5 (first, second, ..., last)
return:Date The date for that was computed with an unreliable time component
*/
function getDateForDayOfWeekInMonth(month, year, dayOfWeek, dayOccurrence) {
    var monthNames = [ "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", 
            "Sept", "Oct", "Nov", "Dec" ];
    var newDate = null;
    // Make sure the parameters passed in are all integers
    month = goodParseInt("" + month);
    year = goodParseInt("" + year);
    dayOfWeek = goodParseInt("" + dayOfWeek);
    dayOccurrence = goodParseInt("" + dayOccurrence);
    // Now create the first day of the month at noon
    newDate = new Date("1 " + monthNames[month] + " " + year + " 12:00:00");
    // Get the current day of the week of this day
    var dow = newDate.getDay();
    // Move to the first day of week occurrence in the month
    if(dayOfWeek > dow) {
        // We need to move forward by a set amount of days
        newDate.setTime(newDate.getTime() + ((dayOfWeek - dow) * sPerDay * 1000));
    } else if(dayOfWeek < dow) {
        // We need to move forward by a set amount of days assuming that dayOccurrence is bigger then dow
        newDate.setTime(newDate.getTime() + (((dayOfWeek + 7) - dow) * sPerDay * 1000));
    }
    // Now compute the amount of weeks to move forward
    var weeksForward = dayOccurrence - 1;
    if(weeksForward >= 4) {
        // The value was set for last so for now just move forward by 3 to place us on the forth
        weeksForward = 3;
    }
    if(weeksForward > 0) {
        // Increase the date by the given amount of weeks
        newDate.setTime(newDate.getTime() + (weeksForward * sPerWeek * 1000));
    }
    if(dayOccurrence == 5) {
        // We are supposed to find the last day of the week so check to see if there is one more occurance or not
        var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        // Handle leap year
        if((month == 1) && (((year - 2000) % 4) == 0)) {
			// It is a leap year so increase the feburay day count to 29
			mdays[1] = 29;
        }
        // Check to see if one more week from now is at or under the total days per month
        if((newDate.getDate() + 7) <= mdays[month]) {
            // There is another week so move forward to it
            newDate.setTime(newDate.getTime() + (sPerWeek * 1000));
        }
    }
            
    // Return the date that was created
    var deleteme = null;
    return newDate;
}

