// This is used to store all the code for going to and from the back side as well as other code that is
// used to handle some actions from the back side

/**
This method will start using the settings that were converted from the back
*/
function useSettings() {
	// Now that properties are loaded set the countdown target
    setCountdownTarget({ eventTime: new Date(countdownStringSetting),
                         eventLabel: eventTitleSetting });
	// Make sure the front images are in the right showing state
	handleImagePositions(imagePositionSetting);
	// Also make sure the front color theme is correct
	updateFrontColorTheme();
}

/**
This will convert the things from the back into settings to be used.
useSettings should be called after this method finishes
*/
function convertBackToSettings() {
	var monthNames = [ "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", 
		"Sept", "Oct", "Nov", "Dec" ];
	var timeString;
	var dateString;
	// Get the hours
	var hourVal;
	// Get the current date to be used later
	var curDate = new Date();
	// First grab the event title setting then the template settings
	eventTitleSetting = document.getElementById("EventTitle_textfield").value;
	template1Setting = document.getElementById("Template1_popup").value;
	template2Setting = document.getElementById("Template2_popup").value;
	usingICalTemplateSetting = document.getElementById("iCal_checkbox_check").checked;
	// Next grab the image settings
	imagePositionSetting = document.getElementById("ImagePos_popup").value;
	imageIdSetting = document.getElementById("Image_popup").value;
	// Now get the path for the image id and use it to set the front images
	imagePathSetting = getImagePath(imageIdSetting);
	setFrontImageSrc(imagePathSetting);
	// Now create the time part of the date
	hourVal = document.getElementById("Hour_popup").value;
	if(document.getElementById("AMPM_popup").value == 1) {
		// It is pm so hours should be between 12 and 23 so just add 12 to the values
		// since 12 is index 0 and 1 is 1 and so on
		hourVal = goodParseInt(hourVal) + 12;
	}
	// Set the hour part of the time string
	timeString = formatTwoDigits(hourVal) + ":";
	// Add the minute part of the time string
	timeString = timeString + formatTwoDigits(document.getElementById("Minute_popup").value) + ":";
	// Add the second part of the time string
	timeString = timeString + formatTwoDigits(document.getElementById("Second_popup").value);
	// Now the time string is in the correct format so handle the repeat value so
	// we can create the correct timeout value
	repeatSetting = document.getElementById("Repeat_popup").value;
    repeatUntilSetting = getRepeatUntilPopupValue();
    if((repeatSetting == 7) || (repeatSetting == 8) || (repeatSetting == 9) || (repeatSetting == 10)) {
        // The repeat extra setting is used for this repeat setting so grab it from the popup
        repeatExtraSetting = document.getElementById("Repeat_Extra_popup").value;
    } else {
        // The repeat extra is not used for this repeat setting
        repeatExtraSetting = "0";
    }
	daySetting = document.getElementById("Day_popup").value;
	// The countdownStringSetting should be put into the format of day month year time
	if(repeatSetting == 0) {
		// Never
		// This is a simple case since the date will just be the same as the value entered
		// with no special cases
		dateString = (goodParseInt(daySetting) + 1) + " " + 
			monthNames[document.getElementById("Month_popup").value] + " " + 
			document.getElementById("Year_popup").value;
	} else if(repeatSetting == 1) {
		// Yearly
		// This case gets complicated for leap years on Feburary but are otherwise
		// pretty simple
		var day = goodParseInt(daySetting) + 1;
		var monthVal = document.getElementById("Month_popup").value;
		var yearVal = curDate.getFullYear();
		if(monthVal == 1) {
			// It set for feburary so compute the day
			if(daySetting == 31) {
				// The value should be the last day of the year
				// By default the last day should be 28
				day = 28;
				// Check if this is is a leap year
				if(((yearVal - 2000) % 4) == 0) {
					// It is a leap year so the last day is 29
					day = 29;
				}
				// We know the year is equal to the current dates year at this point
				if(monthVal < curDate.getMonth()) {
					// We are past the current date found so we need to move to the next year
					yearVal++;
					// Check if this year is a leap year
					if(((yearVal - 2000) % 4) == 0) {
						// It is a leap year so the last day is 29
						day = 29;
					} else {
						// It is not a leap year so the day is 28
						day = 28;
					}
				}
			} else if(daySetting == 28) {
				// This is day 29 which only is for leap years so find the right year
				// Check if this is is a leap year
				if((((yearVal - 2000) % 4) == 0) && (monthVal < curDate.getMonth())) {
					// This year is a leap year but we have already passed the month
					// So we need to go to the next leap year
					yearVal += 4;
				} else if(((yearVal - 2000) % 4) != 0) {
					// The current year is not a leap year so we need to go to the next leap year
					yearVal += (4 - ((yearVal - 2000) % 4));
				}
			}
		}
		// Check if it is past the current day set
		if((yearVal == curDate.getFullYear()) && ((monthVal < curDate.getMonth()) || 
			((monthVal == curDate.getMonth()) && (day < curDate.getDate())))) {
			// We are past the current date found so we need to move to the next year
			yearVal++;
		}
		// We have our date so create the string
		dateString = day + " " + monthNames[monthVal] + " " + yearVal;
	} else if(repeatSetting == 2) {
		// Montly
		// This is pretty straight forward but there can be complications for days over
		// the 28th and the day setting of 31 (Last)
		var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		var day = goodParseInt(daySetting) + 1;
		var monthVal = curDate.getMonth();
		var yearVal = curDate.getFullYear();
		// Check if it is a leap year
		if(((yearVal - 2000) % 4) == 0) {
			// It is a leap year so increase the feburay day count to 29
			mdays[1] = 29;
		}
		if(daySetting == 31) {
			// The day setting is for the last day of the month
			day = mdays[monthVal];
		}
		// Check if it is past the current day set
		if((day < curDate.getDate()) || (day > mdays[monthVal])) {
			// We are past the current day of the month so we need to move to the next month
			do {
				// Increase to the next month
				monthVal++;
				// There is no reason to check for a loop around because December has
				// the max number of days so if it is 31 we would never get here
			} while(day > mdays[monthVal]);
		}
		// We have our date so create the string
		dateString = day + " " + monthNames[monthVal] + " " + yearVal;
	} else if(repeatSetting == 3) {
		// Weekly
		// This needs to handle moving to the next week if we are past that day for this week
		var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		var day = curDate.getDate();
		var dayVal = curDate.getDay();
		var monthVal = curDate.getMonth();
		var yearVal = curDate.getFullYear();
		var daysForward = 0;
		// Check if it is a leap year
		if(((yearVal - 2000) % 4) == 0) {
			// It is a leap year so increase the feburay day count to 29
			mdays[1] = 29;
		}
		// Check if we are past the current day of the week
		if(dayVal > daySetting) {
			// We need to move to the next week
			// The first part tells how many days to get to the end of the week
			// The second part tells how many days to get to the right day or the week
			daysForward = (6 - dayVal) + goodParseInt(daySetting) + 1;
		} else if(dayVal < daySetting) {
			// We need to move forward to the right day
			daysForward = daySetting - dayVal;
		}
		if(daysForward > 0) {
			// Move forward by the given amount of days
			day += daysForward;
			// Check for wrap around
			if(day > mdays[monthVal]) {
				// Wrap the days around for this month
				day = day - mdays[monthVal];
				// Increase the month
				monthVal++;
				// Check for year wrap around
				if(monthVal >= 12) {
					// Move to the next year and reset the month
					yearVal++;
					monthVal = 0;
				}
			 } 
		}
		// We have our date so create the string
		dateString = day + " " + monthNames[monthVal] + " " + yearVal;
	} else if(repeatSetting == 4) {
		// Daily
		// This is very simple and should be the current day month and year with no exceptions
		var day = curDate.getDate();
		var monthVal = curDate.getMonth();
		var yearVal = curDate.getFullYear();
		// We have our date so create the string
		dateString = day + " " + monthNames[monthVal] + " " + yearVal;
	} else if(repeatSetting == 5) {
		// Weekdays
		// This is straight forward if it is already a weekday else we need to move back to the past
		// Friday so the timer is sure to be stopped
		var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		var day = curDate.getDate();
		var dayVal = curDate.getDay();
		var monthVal = curDate.getMonth();
		var yearVal = curDate.getFullYear();
		var daysBackward = 0;
		// Check if it is a leap year
		if(((yearVal - 2000) % 4) == 0) {
			// It is a leap year so increase the feburay day count to 29
			mdays[1] = 29;
		}
		// Check if we on the week end
		if(dayVal == 0) {
			// It is Sunday so move back one week
			daysBackward = 2;
		} else if(dayVal == 6) {
			// It is Saturday so move back to Friday
			daysBackward = 1;
		}
		if(daysBackward > 0) {
			// Move backward by the given amount of days
			day -= daysBackward;
			// Check for going to the previus month
			if(day < 1) {
				// Decrease the month
				monthVal--;		
				// Check for year wrap around
				if(monthVal < 0) {
					// Move to the past year and set the month to December
					yearVal--;
					monthVal = 11;
				}					
				// Wrap the days around for this month
				day = mdays[monthVal] + day;
			 } 
		}
		// We have our date so create the string
		dateString = day + " " + monthNames[monthVal] + " " + yearVal;
	} else if(repeatSetting == 6) {
		// Weekend days
		// This is straight forward if it is already a weekend day else we need to move back to 
		// the past Sunday so the timer is sure to be stopped
		var mdays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		var day = curDate.getDate();
		var dayVal = curDate.getDay();
		var monthVal = curDate.getMonth();
		var yearVal = curDate.getFullYear();
		var daysBackward = 0;
		// Check if it is a leap year
		if(((yearVal - 2000) % 4) == 0) {
			// It is a leap year so increase the feburay day count to 29
			mdays[1] = 29;
		}
		// Check if we are not a weekend day
		if((dayVal != 0) && (dayVal != 6)) {
			// It not a weekend days so move back to Sunday
			daysBackward = dayVal;
		}
		if(daysBackward > 0) {
			// Move backward by the given amount of days
			day -= daysBackward;
			// Check for going to the previus month
			if(day < 1) {
				// Decrease the month
				monthVal--;		
				// Check for year wrap around
				if(monthVal < 0) {
					// Move to the past year and set the month to December
					yearVal--;
					monthVal = 11;
				}					
				// Wrap the days around for this month
				day = mdays[monthVal] + day;
			 } 
		}
		// We have our date so create the string
		dateString = day + " " + monthNames[monthVal] + " " + yearVal;
	} else if(repeatSetting == 7) {   
        // Advanced Yearly
        // We need to find the first time for this repeat on or after the current date
        var monthVal = document.getElementById("Month_popup").value;
        var newDate = getDateForDayOfWeekInMonth(monthVal, curDate.getFullYear(), daySetting, repeatExtraSetting);
        // Now check to see if this date has passed
        if((curDate.getMonth() > monthVal) || ((curDate.getMonth() == monthVal) && 
            (curDate.getDate() > newDate.getDate()))) {
            // We are past this date so compute the new date for next year
            newDate = getDateForDayOfWeekInMonth(monthVal, curDate.getFullYear() + 1, daySetting, repeatExtraSetting);
        }
                
        // Now set the date string to the new date we computed
        dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();
    } else if(repeatSetting == 8) {   
        // Advanced Monthly
        // We need to find the first time for this repeat on or after the current date
        var monthVal = curDate.getMonth();
        var yearVal = curDate.getFullYear();
        var newDate = getDateForDayOfWeekInMonth(monthVal, yearVal, daySetting, repeatExtraSetting);
        // Now check to see if this date has passed
        if(curDate.getDate() > newDate.getDate()) {
            // We are past this date so compute the new date for next month
            monthVal++;
            if(monthVal == 12) {
                // Wrap the month around back to January and increase the year
                monthVal = 0;
                yearVal++;
            }
            newDate = getDateForDayOfWeekInMonth(monthVal, yearVal, daySetting, repeatExtraSetting);
        }
        
        // Now set the date string to the new date we computed
        dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();
    } else if(repeatSetting == 9) {   
        // Advanced Weekly
        // We need to find the first time for this repeat on or after the current date
        var newDate = new Date();
        newDate.setTime(curDate.getTime());
        // We need to set the hours to 12 so that the day switch does not cause a day change because of DLST
        // plus we do not care about the time part of the date
        newDate.setHours(12);
        // Get the current day of the week
        var dow = newDate.getDay();
        if(daySetting > dow) {
            // We need to move forward by a set amount of days
            newDate.setTime(newDate.getTime() + ((goodParseInt(daySetting) - dow) * sPerDay * 1000));
        } else if(daySetting < dow) {
            // We need to move forward by a set amount of days assuming that day setting is bigger then dow
            newDate.setTime(newDate.getTime() + (((goodParseInt(daySetting) + 7) - dow) * sPerDay * 1000));
        }
        // Else we do not need to move forward by any amount
          
        // Now set the date string to the new date we computed
        dateString = newDate.getDate() + " " + monthNames[newDate.getMonth()] + " " + newDate.getFullYear();
    } else if(repeatSetting == 10) {   
        // Advanced Daily
        // This is a simple case since it will just use the current date as the first day
        dateString = curDate.getDate() + " " + monthNames[curDate.getMonth()] + " " + curDate.getFullYear();
    } else if(repeatSetting == 20) {
		// iCal Repeat
		// This is a simple case since the date will just be the same as the value entered
		// with no special cases
		dateString = (goodParseInt(daySetting) + 1) + " " + 
			monthNames[document.getElementById("Month_popup").value] + " " + 
			document.getElementById("Year_popup").value;
	}

	// Add the time string to the countdown string setting
	countdownStringSetting = dateString + " " + timeString;
	
	// Now save the other appearance settings
	// First save the image link settings back to their variables
	imageLinkURLSetting = document.getElementById("Image_Link_textfield").value;
	imageLinkOnSetting = document.getElementById("Use_Link_Real_check").checked;
	imageLinkLockedSetting = document.getElementById("Link_Locked_Real_check").checked;
	// Save the front color theme
	frontColorThemeSetting = document.getElementById("Color_Theme_popup").value;
	// Save the show countdown display settings
	showYearsSetting = document.getElementById("Year_Show_popup").value;
	showExtraSetting = document.getElementById("Extra_Show_popup").value;
	showTimeSetting = document.getElementById("Time_Show_popup").value;
	showJustTimeSetting = document.getElementById("Time_Only_Show_popup").value;
	
	// Make sure the blinking colon vs period is set up correctly
	if(showTimeSetting == "3") {
		// The seconds are being shown so blink the colon not period
		wantBlinkingColon = true;
		wantBlinkingPeriod = false;
	} else {
		// The seconds are not being shown so blink the period not colon
		wantBlinkingColon = false;
		wantBlinkingPeriod = true;
	}	
}

//
// Function: showBack(event)
// Called when the info button is clicked to show the back of the widget
//
// event: onClick event from the info button
//
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
	
	// Create the date used for the countdown
	var cdDate = new Date(countdownStringSetting);
	
	// Start the loading of the web templates and check for updates
	preLoadWebTemplates();
	checkForVersionUpdate();
	
	// Set the image link values into their corresponding components
	setImageLinkText(imageLinkURLSetting, true);
	document.getElementById("Use_Link_Real_check").checked = imageLinkOnSetting;
	document.getElementById("Link_Locked_Real_check").checked = imageLinkLockedSetting;
	// Make sure the text field is in the right enabled state
	linkLockedCheckboxUpdate();
	// Set the color theme popup
	document.getElementById("Color_Theme_popup").value = frontColorThemeSetting;

	// Set the repeat popup value and the month value
	document.getElementById("Repeat_popup").value = repeatSetting;
	document.getElementById("Month_popup").value = cdDate.getMonth();
    repeatUntilDatePopupChanged();
	// Make sure the popup boxes are initialized
	initPopupBoxes();
	// Make sure the calendar popup boxes are in the right enabled state
	handleRepeatValue();
    setRepeatUntilPopupValue(repeatUntilSetting);
    if(repeatExtraSetting != 0) {
        document.getElementById("Repeat_Extra_popup").value = repeatExtraSetting;
    }
	// Set the event label
	document.getElementById("EventTitle_textfield").value = eventTitleSetting;
	// Set the time
	document.getElementById("Minute_popup").value = cdDate.getMinutes();
	document.getElementById("Second_popup").value = cdDate.getSeconds();
	var hour = cdDate.getHours();
	if(hour < 12) {
		// The AMPM popup should be am
		document.getElementById("AMPM_popup").value = 0;
		// Hour should be hour since 12 is at value 0
		document.getElementById("Hour_popup").value = hour;
	} else {
		// The AMPM popup should be pm
		document.getElementById("AMPM_popup").value = 1;
		// Hour should be hour - 12 since 12 is at index 0
		document.getElementById("Hour_popup").value = hour - 12;
	}
	// Set the year
	document.getElementById("Year_popup").value = cdDate.getFullYear();
	// Now set the day
	document.getElementById("Day_popup").value = daySetting;
	// Setup the template popups
	changingTemplate = true;
	// Make sure the iCal template checkbox is in the right state based in the plug-in and setting
	document.getElementById("iCal_checkbox_check").checked = (iCalPluginUsable && usingICalTemplateSetting);
	document.getElementById("Template1_popup").value = template1Setting;
	template1ChangeHandler(false);
	document.getElementById("Template2_popup").value = template2Setting;
	if(template1Setting >= 5) {
		// It is a web template so have the template 2 popup update it self
		template2Change();
	}
	changingTemplate = false;
	// Set the image positions popup
	document.getElementById("ImagePos_popup").value = imagePositionSetting;
	// Set the image id for the image popup and update the change
	document.getElementById("Image_popup").value = imageIdSetting;
	imagePopupChange();
	// Handle the case it is external
	if(imageIdSetting == "100") {
		// It is external so set the external image textfield and handle the change
		document.getElementById("Image_URL_textfield").value = imagePathSetting;
		imageURLChange();
	}
	// Setup the show countdown display popups
	document.getElementById("Year_Show_popup").value = showYearsSetting;
	document.getElementById("Extra_Show_popup").value = showExtraSetting;
	document.getElementById("Time_Show_popup").value = showTimeSetting;
	document.getElementById("Time_Only_Show_popup").value = showJustTimeSetting;
	// Make sure the hours left label gets updated base on these values
	timeOnlyShowPopupChanged();

    if (window.widget) {
        widget.prepareForTransition("ToBack");
	}

    front.style.display="none";
    back.style.display="block";
    
    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
	}
}
