// This file is used to handle the events and hiding/showing of the appearance specific components
// on the back side of the widget

/**
This function will be called when the Appearance button on the back of the widget
has been clicked. This will cause the appearance specific components to show while
the time specific components will be hidden
*/
function appearanceButtonPressed() {
	// Make the time specific components invisible while the appearance ones are visible
	setTimeComponentsVisibility(false);
	setAppearanceComponentsVisibility(true);

	// Make the appearance button disabled now that we are on that part of the widget
	document.getElementById("To_appearance").object.setEnabled(false);
	// The time button should be enabled
	document.getElementById("To_time").object.setEnabled(true);
}

/**
This function will set all the appearance specific components visibility to correspond to the 
value passed into this method
vis:Boolean If the components should be visible or not true for visible false for invisible
*/
function setAppearanceComponentsVisibility(vis) {
	// Assume by default that vis is true
	var visStr = "visible";
	if(vis == false) {
		// Since vis is really false we need to set the string to hidden instead
		visStr = "hidden";
	}
	
	// First hide the main image componets
	document.getElementById("Image_popup").style.visibility = visStr;
	document.getElementById("Image_label").style.visibility = visStr;
	document.getElementById("ImagePos_popup").style.visibility = visStr;
	document.getElementById("Image_Position_label").style.visibility = visStr;
	// Now make sure the external image fields are in the correct visible state
	// since they can be hidden even if everything else is supposed to be visible
	if(vis == false) {
		// Even if they are not visible already they should stay hidden
		document.getElementById("External_Image_text").style.visibility = visStr;
		document.getElementById("Image_URL_textfield").style.visibility = visStr;
	} else {
		// The visiblity depends on if external image is selected in the image popup
		if(document.getElementById("Image_popup").value == 100) {
			// External image is selected so they should be visible
			document.getElementById("External_Image_text").style.visibility = visStr;
			document.getElementById("Image_URL_textfield").style.visibility = visStr;
			// The enabled state should be based on the images visiblity
			document.getElementById("Image_URL_textfield").disabled = !vis;
		} else {
			// External image is not selected so they should be hidden
			document.getElementById("External_Image_text").style.visibility = "hidden";
			document.getElementById("Image_URL_textfield").style.visibility = "hidden";
		}
	}
	// Now make sure the image link components are in the correct state
	document.getElementById("Image_Link_text").style.visibility = visStr;
	document.getElementById("Image_Link_textfield").style.visibility = visStr;
	document.getElementById("Use_Link_check").style.visibility = visStr;
	document.getElementById("Link_Locked_check").style.visibility = visStr;
	// If the visiblity is on make sure that the image text field is in the right enabled state 
	if(vis) {
		// This method will make sure the image link is in the correct enable state
		linkLockedCheckboxUpdate();
	}
	// Next handle the color theme
	document.getElementById("Color_Theme_text").style.visibility = visStr;
	document.getElementById("Color_Theme_popup").style.visibility = visStr;
	// Finally make sure the countdown display components are in the right state
	document.getElementById("Countdown_Display_text").style.visibility = visStr;
	document.getElementById("Year_Show_popup").style.visibility = visStr;
	document.getElementById("Year_Show_text").style.visibility = visStr;
	document.getElementById("Extra_Show_popup").style.visibility = visStr;
	document.getElementById("Extra_Show_text").style.visibility = visStr;
	document.getElementById("Days_Show_popup").style.visibility = visStr;
	document.getElementById("Days_Show_text").style.visibility = visStr;
	// Make sure the time part of the countdown is setup correctly
	document.getElementById("Time_Show_popup").style.visibility = visStr;
	document.getElementById("Time_Show_text").style.visibility = visStr;
	document.getElementById("Time_Only_Show_popup").style.visibility = visStr;
	document.getElementById("Time_Only_Show_text").style.visibility = visStr;
	if(vis) {
		// Visiblity only depends on if the time only show popup is not equal to value zero
		if(document.getElementById("Time_Only_Show_popup").value == "0") {
			// The time only left text should not be visible
			document.getElementById("Time_Only_Left_text").style.visibility = "hidden";
		} else {
			// Never is not selected so hours left text should be vislbile like everything else
			document.getElementById("Time_Only_Left_text").style.visibility = visStr;
		}
	} else {
		// Visible is off so make sure the hours left text is not visible like verything else
		document.getElementById("Time_Only_Left_text").style.visibility = visStr;
	}
}

/**
This function is called when the time only show popup's value changes.
This will make sure that the hours left text label is set to the right visible state
*/
function timeOnlyShowPopupChanged() {
	// Get the new value of the popup
	var val = document.getElementById("Time_Only_Show_popup").value;
	if((val == "0") || (document.getElementById("To_appearance").object.enabled)) {
		// The label should be hidden
		document.getElementById("Time_Only_Left_text").style.visibility = "hidden";
	} else {
		// Never is not selected so the label should be visible
		document.getElementById("Time_Only_Left_text").style.visibility = "visible";
	}
}

/**
This function is called when the link locked checkbox's checked state has been changed
or needs to update the enable state of the corresponding image link text field
*/
function linkLockedCheckboxUpdate() {
	if(document.getElementById("Link_Locked_Real_check").checked) {
		// It is checked so disable the textfield
		document.getElementById("Image_Link_textfield").disabled = true;
	} else {
		// It is not checked so make sure the text field is enabled
		document.getElementById("Image_Link_textfield").disabled = false;
	}
}

/**
This will try to set the text in the image link text field. This will always succeed
if force is true or the link locked checkbox is not checked
str:String The string to set in the image link text field
force:Boolean true to force the string to be set in the text field, false to depend on
   the state of the link locked checkbox
*/
function setImageLinkText(str, force) {
	// Check if either force is true or the checkbox is not checked
	if((force) || (document.getElementById("Link_Locked_Real_check").checked == false)) {
		// We should set the text of the text field
		document.getElementById("Image_Link_textfield").value = str;
	}
}
